/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.BuilderErrorHandler;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class SAXBuilder {
    private boolean validate;
    private boolean expand = true;
    private ErrorHandler saxErrorHandler = null;
    private EntityResolver saxEntityResolver = null;
    private DTDHandler saxDTDHandler = null;
    private XMLFilter saxXMLFilter = null;
    protected JDOMFactory factory = null;
    private boolean ignoringWhite = false;
    private HashMap features = new HashMap(5);
    private HashMap properties = new HashMap(5);

    public SAXBuilder() {
        this(false);
    }

    public SAXBuilder(boolean bl) {
        this.validate = bl;
    }

    public void setFactory(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory;
    }

    public void setValidation(boolean bl) {
        this.validate = bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.saxErrorHandler = errorHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.saxDTDHandler = dTDHandler;
    }

    public void setXMLFilter(XMLFilter xMLFilter) {
        this.saxXMLFilter = xMLFilter;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringWhite = bl;
    }

    public void setFeature(String string, boolean bl) {
        this.features.put(string, bl);
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    private Document build(InputSource inputSource) throws JDOMException {
        SAXHandler sAXHandler = null;
        try {
            Object object;
            sAXHandler = this.createContentHandler();
            this.configureContentHandler(sAXHandler);
            XMLReader xMLReader = this.createParser();
            if (this.saxXMLFilter != null) {
                object = this.saxXMLFilter;
                while (object.getParent() instanceof XMLFilter) {
                    object = (XMLFilter)object.getParent();
                }
                object.setParent(xMLReader);
                xMLReader = this.saxXMLFilter;
            }
            this.configureParser(xMLReader, sAXHandler);
            xMLReader.parse(inputSource);
            object = sAXHandler.getDocument();
            return object;
        }
        catch (Exception exception) {
            if (exception instanceof SAXParseException) {
                SAXParseException sAXParseException = (SAXParseException)exception;
                String string = sAXParseException.getSystemId();
                if (string != null) {
                    throw new JDOMException("Error on line " + sAXParseException.getLineNumber() + " of document " + string, exception);
                }
                throw new JDOMException("Error on line " + sAXParseException.getLineNumber(), exception);
            }
            if (exception instanceof JDOMException) {
                throw (JDOMException)exception;
            }
            throw new JDOMException("Error in building", exception);
        }
        finally {
            sAXHandler = null;
        }
    }

    protected SAXHandler createContentHandler() throws Exception {
        SAXHandler sAXHandler = new SAXHandler(this.factory);
        return sAXHandler;
    }

    protected void configureContentHandler(SAXHandler sAXHandler) throws Exception {
        sAXHandler.setExpandEntities(this.expand);
        sAXHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
    }

    protected XMLReader createParser() throws Exception {
        XMLReader xMLReader = null;
        try {
            Class<?> clazz = Class.forName("javax.xml.parsers.SAXParserFactory");
            Method method = clazz.getMethod("newInstance", null);
            Object object = method.invoke(null, null);
            Method method2 = clazz.getMethod("setValidating", Boolean.TYPE);
            method2.invoke(object, this.validate);
            Method method3 = clazz.getMethod("newSAXParser", null);
            Object object2 = method3.invoke(object, null);
            Class<?> clazz2 = object2.getClass();
            Method method4 = clazz2.getMethod("getXMLReader", null);
            xMLReader = (XMLReader)method4.invoke(object2, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return xMLReader;
    }

    protected void configureParser(XMLReader xMLReader, SAXHandler sAXHandler) throws Exception {
        block24: {
            xMLReader.setContentHandler(sAXHandler);
            if (this.saxEntityResolver != null) {
                xMLReader.setEntityResolver(this.saxEntityResolver);
            }
            if (this.saxDTDHandler != null) {
                xMLReader.setDTDHandler(this.saxDTDHandler);
            } else {
                xMLReader.setDTDHandler(sAXHandler);
            }
            if (this.saxErrorHandler != null) {
                xMLReader.setErrorHandler(this.saxErrorHandler);
            } else {
                xMLReader.setErrorHandler(new BuilderErrorHandler());
            }
            for (Object object : this.features.keySet()) {
                Object object2 = (Boolean)this.features.get(object);
                this.internalSetFeature(xMLReader, (String)object, (Boolean)object2, (String)object);
            }
            for (Object object2 : this.properties.keySet()) {
                Object v = this.properties.get(object2);
                this.internalSetProperty(xMLReader, (String)object2, v, (String)object2);
            }
            boolean bl = false;
            try {
                xMLReader.setProperty("http://xml.org/sax/handlers/LexicalHandler", sAXHandler);
                bl = true;
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
            if (!bl) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", sAXHandler);
                    bl = true;
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            if (!this.expand) {
                try {
                    xMLReader.setProperty("http://xml.org/sax/properties/declaration-handler", sAXHandler);
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    // empty catch block
                }
            }
            try {
                this.internalSetFeature(xMLReader, "http://xml.org/sax/features/validation", this.validate, "Validation");
            }
            catch (JDOMException jDOMException) {
                if (!this.validate) break block24;
                throw jDOMException;
            }
        }
        this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespaces", true, "Namespaces");
        this.internalSetFeature(xMLReader, "http://xml.org/sax/features/namespace-prefixes", false, "Namespace prefixes");
        try {
            if (xMLReader.getFeature("http://xml.org/sax/features/external-general-entities") != this.expand) {
                xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", this.expand);
            }
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    private void internalSetFeature(XMLReader xMLReader, String string, boolean bl, String string2) throws JDOMException {
        try {
            xMLReader.setFeature(string, bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " feature not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " feature not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    private void internalSetProperty(XMLReader xMLReader, String string, Object object, String string2) throws JDOMException {
        try {
            xMLReader.setProperty(string, object);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new JDOMException(string2 + " property not supported for SAX driver " + xMLReader.getClass().getName());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new JDOMException(string2 + " property not recognized for SAX driver " + xMLReader.getClass().getName());
        }
    }

    public Document build(InputStream inputStream) throws JDOMException {
        return this.build(new InputSource(inputStream));
    }

    public Document build(Reader reader) throws JDOMException {
        return this.build(new InputSource(reader));
    }

    protected URL fileToURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }

    public Document build(File file) throws JDOMException {
        try {
            FileReader fileReader = new FileReader(file);
            return this.build(fileReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDOMException("Error in building", fileNotFoundException);
        }
    }
}

