/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.input.DefaultJDOMFactory;
import org.jdom.input.JDOMFactory;
import org.xml.sax.Attributes;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXHandler
extends DefaultHandler
implements LexicalHandler,
DeclHandler,
DTDHandler {
    private Document document;
    protected Stack stack;
    protected boolean atRoot;
    protected boolean inDTD = false;
    protected boolean inInternalSubset = false;
    protected boolean previousCDATA = false;
    protected boolean inCDATA = false;
    private boolean expand = true;
    protected boolean suppress = false;
    private int entityDepth = 0;
    private StringBuffer buffer = new StringBuffer();
    private StringBuffer textBuffer = new StringBuffer(4096);
    private Map externalEntities;
    private JDOMFactory factory;
    private boolean ignoringWhite = false;
    private Locator locator;

    public SAXHandler(Document document) {
        this(new DefaultJDOMFactory());
        this.document = document;
    }

    public SAXHandler() {
        this((JDOMFactory)null);
    }

    public SAXHandler(JDOMFactory jDOMFactory) {
        this.factory = jDOMFactory != null ? jDOMFactory : new DefaultJDOMFactory();
        this.atRoot = true;
        this.stack = new Stack();
        this.externalEntities = new HashMap();
        this.document = this.factory.document(null);
    }

    public Document getDocument() {
        return this.document;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public void setExpandEntities(boolean bl) {
        this.expand = bl;
    }

    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setIgnoringElementContentWhitespace(boolean bl) {
        this.ignoringWhite = bl;
    }

    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) {
        this.externalEntities.put(string, new String[]{string2, string3});
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ENTITY ").append(string);
        this.appendExternalId(string2, string3);
        this.buffer.append(">\n");
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ATTLIST ").append(string).append(" ").append(string2).append(" ").append(string3).append(" ");
        if (string4 != null) {
            this.buffer.append(string4);
        } else {
            this.buffer.append("\"").append(string5).append("\"");
        }
        if (string4 != null && string4.equals("#FIXED")) {
            this.buffer.append(" \"").append(string5).append("\"");
        }
        this.buffer.append(">\n");
    }

    @Override
    public void elementDecl(String string, String string2) {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ELEMENT ").append(string).append(" ").append(string2).append(">\n");
    }

    @Override
    public void internalEntityDecl(String string, String string2) {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ENTITY ");
        if (string.startsWith("%")) {
            this.buffer.append("% ").append(string.substring(1));
        } else {
            this.buffer.append(string);
        }
        this.buffer.append(" \"").append(string2).append("\">\n");
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        if (this.atRoot) {
            this.document.addContent(this.factory.processingInstruction(string, string2));
        } else {
            this.getCurrentElement().addContent(this.factory.processingInstruction(string, string2));
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        if (string.startsWith("%")) {
            return;
        }
        this.flushCharacters();
        this.getCurrentElement().addContent(this.factory.entityRef(string));
    }

    @Override
    public void startPrefixMapping(String string, String string2) {
        if (this.suppress) {
            return;
        }
    }

    @Override
    public void endPrefixMapping(String string) {
        if (this.suppress) {
            return;
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.suppress) {
            return;
        }
        Element element = this.factory.element(string2);
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Attribute attribute = null;
            String string4 = attributes.getLocalName(i);
            attribute = this.factory.attribute(string4, attributes.getValue(i));
            element.setAttribute(attribute);
        }
        this.flushCharacters();
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.stack.push(element);
            this.atRoot = false;
        } else {
            this.getCurrentElement().addContent(element);
            this.stack.push(element);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.suppress || n2 == 0) {
            return;
        }
        if (this.previousCDATA != this.inCDATA) {
            this.flushCharacters();
        }
        this.textBuffer.append(cArray, n, n2);
    }

    protected void flushCharacters() throws SAXException {
        if (this.textBuffer.length() == 0) {
            this.previousCDATA = this.inCDATA;
            return;
        }
        String string = this.textBuffer.substring(0);
        this.textBuffer.setLength(0);
        if (this.previousCDATA) {
            this.getCurrentElement().addContent(this.factory.cdata(string));
        } else {
            this.getCurrentElement().addContent(this.factory.text(string));
        }
        this.previousCDATA = this.inCDATA;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        if (this.suppress) {
            return;
        }
        if (this.ignoringWhite) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        this.textBuffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        try {
            this.stack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            throw new SAXException("Ill-formed XML document (missing opening tag for " + string2 + ")");
        }
        if (this.stack.empty()) {
            this.atRoot = true;
        }
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.flushCharacters();
        this.document.setDocType(this.factory.docType(string, string2, string3));
        this.inDTD = true;
        this.inInternalSubset = true;
    }

    @Override
    public void endDTD() {
        this.document.getDocType().setInternalSubset(this.buffer.toString());
        this.inDTD = false;
        this.inInternalSubset = false;
    }

    @Override
    public void startEntity(String string) throws SAXException {
        ++this.entityDepth;
        if (this.expand || this.entityDepth > 1) {
            return;
        }
        if (string.equals("[dtd]")) {
            this.inInternalSubset = false;
            return;
        }
        if (!(this.inDTD || string.equals("amp") || string.equals("lt") || string.equals("gt") || string.equals("apos") || string.equals("quot") || this.expand)) {
            String string2 = null;
            String string3 = null;
            String[] stringArray = (String[])this.externalEntities.get(string);
            if (stringArray != null) {
                string2 = stringArray[0];
                string3 = stringArray[1];
            }
            if (!this.atRoot && !this.stack.isEmpty()) {
                this.flushCharacters();
                EntityRef entityRef = this.factory.entityRef(string, string2, string3);
                this.getCurrentElement().addContent(entityRef);
            }
            this.suppress = true;
        }
    }

    @Override
    public void endEntity(String string) {
        --this.entityDepth;
        if (this.entityDepth == 0) {
            this.suppress = false;
        }
        if (string.equals("[dtd]")) {
            this.inInternalSubset = true;
        }
    }

    @Override
    public void startCDATA() {
        if (this.suppress) {
            return;
        }
        this.inCDATA = true;
    }

    @Override
    public void endCDATA() {
        if (this.suppress) {
            return;
        }
        this.previousCDATA = true;
        this.inCDATA = false;
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.suppress) {
            return;
        }
        this.flushCharacters();
        String string = new String(cArray, n, n2);
        if (this.inDTD && this.inInternalSubset && !this.expand) {
            this.buffer.append("  <!--").append(string).append("-->\n");
            return;
        }
        if (!this.inDTD && !string.equals("")) {
            if (this.stack.empty()) {
                this.document.addContent(this.factory.comment(string));
            } else {
                this.getCurrentElement().addContent(this.factory.comment(string));
            }
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!NOTATION ").append(string);
        this.appendExternalId(string2, string3);
        this.buffer.append(">\n");
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (!this.inInternalSubset) {
            return;
        }
        this.buffer.append("  <!ENTITY ").append(string);
        this.appendExternalId(string2, string3);
        this.buffer.append(" NDATA ").append(string4);
        this.buffer.append(">\n");
    }

    protected void appendExternalId(String string, String string2) {
        if (string != null) {
            this.buffer.append(" PUBLIC \"").append(string).append("\"");
        }
        if (string2 != null) {
            if (string == null) {
                this.buffer.append(" SYSTEM ");
            } else {
                this.buffer.append(" ");
            }
            this.buffer.append("\"").append(string2).append("\"");
        }
    }

    protected Element getCurrentElement() throws SAXException {
        try {
            return (Element)this.stack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            throw new SAXException("Ill-formed XML document (multiple root elements detected)");
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }
}

