/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.arrays;

import java.io.Serializable;

public final class BooleanArray
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULTSIZE = 10;
    private int count = 0;
    private boolean[] elements;

    public BooleanArray() {
        this(10);
    }

    public BooleanArray(int n) {
        this.elements = new boolean[n];
    }

    public void add(boolean bl) {
        int n = this.elements.length;
        if (this.count + 1 >= n) {
            boolean[] blArray = new boolean[1 + n * 3 / 2];
            System.arraycopy(this.elements, 0, blArray, 0, n);
            this.elements = blArray;
        }
        this.elements[this.count++] = bl;
    }

    public boolean get(int n) {
        if (n < 0 || n >= this.count) {
            throw new IllegalArgumentException("BooleanArray.get()");
        }
        return this.elements[n];
    }

    public boolean[] getValues() {
        boolean[] blArray = new boolean[this.count];
        System.arraycopy(this.elements, 0, blArray, 0, this.count);
        return blArray;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public void set(int n, boolean bl) {
        if (n < 0 || n >= this.count) {
            throw new IllegalArgumentException("BooleanArray.set()");
        }
        this.elements[n] = bl;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < this.count; ++i) {
            if (0 != i) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toCommaString() {
        return BooleanArray.toString(this.elements, this.count);
    }

    public static final String toString(boolean[] blArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(blArray[i]);
        }
        return stringBuffer.toString();
    }

    public void clear() {
        this.count = 0;
    }
}

