/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.arrays;

import java.io.Serializable;

public final class DoubleArray
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULTSIZE = 10;
    private int count = 0;
    private double[] elements;

    public DoubleArray() {
        this(10);
    }

    public DoubleArray(int n) {
        this.elements = new double[n];
    }

    public void clear() {
        this.count = 0;
    }

    public void add(double[] dArray) {
        int n = dArray.length;
        int n2 = this.elements.length;
        if (this.count + n >= n2) {
            double[] dArray2 = new double[n + n2 * 3 / 2];
            System.arraycopy(this.elements, 0, dArray2, 0, n2);
            this.elements = dArray2;
        }
        System.arraycopy(dArray, 0, this.elements, this.count, n);
        this.count += n;
    }

    public double get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public void add(double d) {
        int n = this.elements.length;
        if (this.count + 1 >= n) {
            double[] dArray = new double[1 + n * 3 / 2];
            System.arraycopy(this.elements, 0, dArray, 0, n);
            this.elements = dArray;
        }
        this.elements[this.count++] = d;
    }

    public double[] getValues() {
        double[] dArray = new double[this.count];
        System.arraycopy(this.elements, 0, dArray, 0, this.count);
        return dArray;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public int size() {
        return this.count;
    }

    public static final String toString(double[] dArray) {
        return DoubleArray.toString(dArray, dArray.length);
    }

    public static final String toString(double[] dArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(dArray[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "[" + DoubleArray.toString(this.elements, this.count) + "]";
    }
}

