/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.arrays;

import java.io.Serializable;
import java.util.StringTokenizer;

public final class IntArray
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULTSIZE = 10;
    private int count = 0;
    private int[] elements;

    public IntArray() {
        this(10);
    }

    public IntArray(int n) {
        this.elements = new int[n];
    }

    public IntArray(String string, String string2) {
        this();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            this.add(Integer.parseInt(stringTokenizer.nextToken()));
        }
    }

    public void add(int n) {
        int n2 = this.elements.length;
        if (this.count + 1 >= n2) {
            int[] nArray = new int[1 + n2 * 3 / 2];
            System.arraycopy(this.elements, 0, nArray, 0, n2);
            this.elements = nArray;
        }
        this.elements[this.count++] = n;
    }

    public void add(int n, int n2) {
        int n3 = this.elements.length;
        if (this.count + 1 >= n3) {
            int[] nArray = new int[1 + n3 * 3 / 2];
            System.arraycopy(this.elements, 0, nArray, 0, n3);
            this.elements = nArray;
        }
        if (n < this.count) {
            for (int i = this.elements.length - 1; i > n; --i) {
                this.elements[i] = this.elements[i - 1];
            }
        }
        this.elements[n] = n2;
        ++this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.count && i < this.elements.length; ++i) {
            if (this.elements[i] != n) continue;
            return true;
        }
        return false;
    }

    public int get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public int[] getValues() {
        int[] nArray = new int[this.count];
        System.arraycopy(this.elements, 0, nArray, 0, this.count);
        return nArray;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public void set(int n, int n2) {
        if (n >= this.count) {
            int n3 = this.elements.length;
            int[] nArray = new int[n3 + 10];
            System.arraycopy(this.elements, 0, nArray, 0, n3);
            this.elements = nArray;
        }
        this.elements[n] = n2;
        if (n >= this.count) {
            this.count = n + 1;
        }
    }

    public int size() {
        return this.count;
    }

    public static int[] parse(String string) {
        IntArray intArray = new IntArray();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;:");
        while (stringTokenizer.hasMoreTokens()) {
            intArray.add(Integer.parseInt(stringTokenizer.nextToken()));
        }
        return intArray.getValues();
    }

    public static final String toString(int[] nArray) {
        return IntArray.toString(nArray, nArray.length);
    }

    public static final String toString(int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "[" + IntArray.toString(this.elements, this.count) + "]";
    }

    public int indexOf(int n) {
        for (int i = 0; i < this.count && i < this.elements.length; ++i) {
            if (this.elements[i] != n) continue;
            return i;
        }
        return -1;
    }

    public String toCommaString() {
        return IntArray.toString(this.elements, this.count);
    }
}

