/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.arrays;

import java.io.Serializable;

public final class StringArray
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULTSIZE = 10;
    private int count = 0;
    private String[] elements;

    public StringArray() {
        this(10);
    }

    public StringArray(int n) {
        this.elements = new String[n];
    }

    public void add(String string) {
        int n = this.elements.length;
        if (this.count + 1 >= n) {
            String[] stringArray = new String[1 + n * 3 / 2];
            System.arraycopy(this.elements, 0, stringArray, 0, n);
            this.elements = stringArray;
        }
        this.elements[this.count++] = string;
    }

    public void add(String[] stringArray) {
        if (0 != stringArray.length) {
            int n = this.elements.length;
            if (this.count + stringArray.length >= n) {
                String[] stringArray2 = new String[stringArray.length + n * 3 / 2];
                System.arraycopy(this.elements, 0, stringArray2, 0, n);
                this.elements = stringArray2;
            }
            System.arraycopy(stringArray, 0, this.elements, this.count, stringArray.length);
            this.count += stringArray.length;
        }
    }

    public void clear() {
        this.count = 0;
    }

    public boolean contains(String string) {
        for (int i = 0; i < this.count && i < this.elements.length; ++i) {
            if (!(null == string ? null == this.elements[i] : string.equals(this.elements[i]))) continue;
            return true;
        }
        return false;
    }

    public String get(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.elements[n];
    }

    public String[] getValues() {
        String[] stringArray = new String[this.count];
        System.arraycopy(this.elements, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public void set(int n, String string) {
        if (n >= this.count) {
            int n2 = this.elements.length;
            String[] stringArray = new String[n2 + 10];
            System.arraycopy(this.elements, 0, stringArray, 0, n2);
            this.elements = stringArray;
        }
        this.elements[n] = string;
        this.count = n + 1;
    }

    public int size() {
        return this.count;
    }

    public static final String toString(String[] stringArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (0 != i) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "[" + StringArray.toString(this.elements, this.count) + "]";
    }

    public void compact() {
        this.elements = StringArray.compactStrings(this.elements);
    }

    public static String[] compactStrings(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            n += stringArray[i].length();
        }
        char[] cArray = new char[n];
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i].getChars(0, stringArray[i].length(), cArray, n);
            n += stringArray[i].length();
        }
        String string = new String(cArray);
        n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = string.substring(n, n += stringArray[i].length());
        }
        return stringArray2;
    }

    public boolean remove(String string) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(string)) continue;
            System.arraycopy(this.elements, i + 1, this.elements, i, this.count - i - 1);
            --this.count;
            return true;
        }
        return false;
    }
}

