/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class FastFifo {
    private Entry head;
    private int size;

    public boolean isEmpty() {
        return 0 == this.size;
    }

    public void addAll(List list) {
        if (list instanceof RandomAccess) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                this.add(list.get(i));
            }
        } else {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    public void add(Object object) {
        if (null == object) {
            throw new IllegalArgumentException("FastFifo.add() : cannot add null values");
        }
        this.head = new Entry(object, this.head);
        ++this.size;
    }

    public Object removeFirst() {
        if (null == this.head) {
            throw new EmptyStackException();
        }
        Entry entry = this.head;
        this.head = entry.next;
        --this.size;
        return entry.element;
    }

    protected static final class Entry
    implements Serializable {
        private static final long serialVersionUID = 520L;
        Object element;
        Entry next;

        protected Entry(Object object, Entry entry) {
            this.element = object;
            this.next = entry;
        }

        public Entry next() {
            return this.next;
        }

        public Object value() {
            return this.element;
        }
    }
}

