/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import java.io.Serializable;

public final class IntDoubleTable
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULT_SIZE = 10;
    private static final float DEFAULT_LOAD = 0.75f;
    private final float loadFactor;
    private DoubleEntry[] table;
    private int count;
    private int threshold;

    public IntDoubleTable() {
        this(10, 0.75f);
    }

    public IntDoubleTable(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity : " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load : " + f);
        }
        if (0 == n) {
            n = 1;
        }
        this.table = new DoubleEntry[n];
        this.loadFactor = f;
        this.count = 0;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        DoubleEntry[] doubleEntryArray = this.table;
        synchronized (this.table) {
            if (this.count > 0) {
                this.count = 0;
                this.table = new DoubleEntry[this.table.length];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public double get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        DoubleEntry doubleEntry = this.table[n2];
        while (null != doubleEntry) {
            if (n == doubleEntry.key) {
                return doubleEntry.value;
            }
            doubleEntry = doubleEntry.next;
        }
        return -1.0;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int n, double d) {
        DoubleEntry[] doubleEntryArray = this.table;
        synchronized (this.table) {
            if (this.count + 1 >= this.threshold) {
                this.rehash();
            }
            int n2 = (n & Integer.MAX_VALUE) % this.table.length;
            DoubleEntry doubleEntry = this.table[n2];
            while (null != doubleEntry) {
                if (doubleEntry.key == n) {
                    doubleEntry.value = d;
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return;
                }
                doubleEntry = doubleEntry.next;
            }
            this.table[n2] = new DoubleEntry(d, n, this.table[n2]);
            ++this.count;
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    private void rehash() {
        int n = this.table.length;
        DoubleEntry[] doubleEntryArray = this.table;
        int n2 = n * 2 + 1;
        DoubleEntry[] doubleEntryArray2 = new DoubleEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = doubleEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            DoubleEntry doubleEntry = doubleEntryArray[n3];
            while (doubleEntry != null) {
                DoubleEntry doubleEntry2 = doubleEntry;
                doubleEntry = doubleEntry.next;
                int n4 = (doubleEntry2.key & Integer.MAX_VALUE) % n2;
                doubleEntry2.next = doubleEntryArray2[n4];
                doubleEntryArray2[n4] = doubleEntry2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n) {
        DoubleEntry[] doubleEntryArray = this.table;
        synchronized (this.table) {
            int n2 = (n & Integer.MAX_VALUE) % this.table.length;
            DoubleEntry doubleEntry = this.table[n2];
            DoubleEntry doubleEntry2 = null;
            while (doubleEntry != null) {
                if (doubleEntry.key == n) {
                    if (doubleEntry2 != null) {
                        doubleEntry2.next = doubleEntry.next;
                    } else {
                        this.table[n2] = doubleEntry.next;
                    }
                    --this.count;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                doubleEntry2 = doubleEntry;
                doubleEntry = doubleEntry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public int size() {
        return this.count;
    }

    public int[] getKeys() {
        int[] nArray = new int[this.size()];
        if (this.count > 0) {
            int n = 0;
            for (int i = 0; n < this.size() && i < this.table.length; ++i) {
                DoubleEntry doubleEntry = this.table[i];
                if (null == doubleEntry) continue;
                nArray[n] = doubleEntry.key;
                ++n;
                doubleEntry = doubleEntry.next;
                while (null != doubleEntry) {
                    nArray[n] = doubleEntry.key;
                    ++n;
                    doubleEntry = doubleEntry.next;
                }
            }
            if (n == this.size()) {
                return nArray;
            }
        }
        return new int[0];
    }

    public static final class DoubleEntry
    implements Serializable {
        private static final long serialVersionUID = 520L;
        int key;
        double value;
        DoubleEntry next;

        protected DoubleEntry(double d, int n, DoubleEntry doubleEntry) {
            this.key = n;
            this.value = d;
            this.next = doubleEntry;
        }

        public int getKey() {
            return this.key;
        }

        public double getValue() {
            return this.value;
        }
    }
}

