/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import java.io.Serializable;

public final class IntIntTableNotSynchronized
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULT_SIZE = 10;
    private static final float DEFAULT_LOAD = 0.75f;
    private final float loadFactor;
    private IntEntry[] table;
    private int count;
    private int threshold;

    public IntIntTableNotSynchronized() {
        this(10, 0.75f);
    }

    public IntIntTableNotSynchronized(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity : " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load : " + f);
        }
        if (0 == n) {
            n = 1;
        }
        this.table = new IntEntry[n];
        this.loadFactor = f;
        this.count = 0;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    public void clear() {
        if (this.count > 0) {
            this.count = 0;
            this.table = new IntEntry[this.table.length];
        }
    }

    public int get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        IntEntry intEntry = this.table[n2];
        while (null != intEntry) {
            if (n == intEntry.key) {
                return intEntry.value;
            }
            intEntry = intEntry.next;
        }
        return -1;
    }

    public int[] getKeys() {
        int[] nArray = new int[this.size()];
        if (this.count > 0) {
            int n = 0;
            for (int i = 0; n < this.size() && i < this.table.length; ++i) {
                IntEntry intEntry = this.table[i];
                if (null == intEntry) continue;
                nArray[n] = intEntry.key;
                ++n;
                intEntry = intEntry.next;
                while (null != intEntry) {
                    nArray[n] = intEntry.key;
                    ++n;
                    intEntry = intEntry.next;
                }
            }
            if (n == this.size()) {
                return nArray;
            }
        }
        return new int[0];
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public void increment(int n, int n2) {
        if (this.count + 1 >= this.threshold) {
            this.rehash();
        }
        int n3 = (n & Integer.MAX_VALUE) % this.table.length;
        IntEntry intEntry = this.table[n3];
        while (null != intEntry) {
            if (intEntry.key == n) {
                intEntry.value += n2;
                return;
            }
            intEntry = intEntry.next;
        }
        this.table[n3] = new IntEntry(n2, n, this.table[n3]);
        ++this.count;
    }

    public void put(int n, int n2) {
        if (this.count + 1 >= this.threshold) {
            this.rehash();
        }
        int n3 = (n & Integer.MAX_VALUE) % this.table.length;
        IntEntry intEntry = this.table[n3];
        while (null != intEntry) {
            if (intEntry.key == n) {
                intEntry.value = n2;
                return;
            }
            intEntry = intEntry.next;
        }
        this.table[n3] = new IntEntry(n2, n, this.table[n3]);
        ++this.count;
    }

    private void rehash() {
        int n = this.table.length;
        IntEntry[] intEntryArray = this.table;
        int n2 = n * 2 + 1;
        IntEntry[] intEntryArray2 = new IntEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = intEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            IntEntry intEntry = intEntryArray[n3];
            while (intEntry != null) {
                IntEntry intEntry2 = intEntry;
                intEntry = intEntry.next;
                int n4 = (intEntry2.key & Integer.MAX_VALUE) % n2;
                intEntry2.next = intEntryArray2[n4];
                intEntryArray2[n4] = intEntry2;
            }
        }
    }

    public void remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.table.length;
        IntEntry intEntry = this.table[n2];
        IntEntry intEntry2 = null;
        while (intEntry != null) {
            if (intEntry.key == n) {
                if (intEntry2 != null) {
                    intEntry2.next = intEntry.next;
                } else {
                    this.table[n2] = intEntry.next;
                }
                --this.count;
                return;
            }
            intEntry2 = intEntry;
            intEntry = intEntry.next;
        }
    }

    public int size() {
        return this.count;
    }

    public static final class IntEntry
    implements Serializable {
        private static final long serialVersionUID = 520L;
        public int key;
        public int value;
        public IntEntry next;

        protected IntEntry(int n, int n2, IntEntry intEntry) {
            this.key = n2;
            this.value = n;
            this.next = intEntry;
        }
    }
}

