/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import com.adesoft.collections.Entry;
import com.adesoft.collections.EntryValuesIterator;
import com.adesoft.collections.HashEntryEnum;
import com.adesoft.collections.HashEnum;
import com.adesoft.collections.HashKeyEnum;
import com.adesoft.collections.PrimeFinder;
import com.adesoft.log.Category;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;

public class MyHashTable
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance("com.adesoft.collections.MyHashTable");
    private static final int DEFAULT_SIZE = 11;
    private static final float DEFAULT_LOAD = 0.75f;
    private Entry[] table;
    private int count;
    private int threshold;

    public MyHashTable() {
        this(11);
    }

    public MyHashTable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity : " + n);
        }
        if (0 == n) {
            n = 1;
        }
        this.table = new Entry[n];
        this.count = 0;
        this.threshold = (int)((float)n * 0.75f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            int n = 0;
            int n2 = this.table.length;
            while (--n2 >= 0) {
                Entry entry = this.table[n2];
                while (null != entry) {
                    objectArray[n++] = entry.getValue();
                    entry = entry.next;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            int n = 0;
            int n2 = this.table.length;
            while (--n2 >= 0) {
                Entry entry = this.table[n2];
                while (null != entry) {
                    objectArray[n++] = entry.getValue();
                    entry = entry.next;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            if (this.count > 0) {
                this.count = 0;
                this.table = new Entry[this.table.length];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Iterator entries() {
        return new HashEntryEnum(this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(int n) {
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            Entry entry = this.table[(n & Integer.MAX_VALUE) % this.table.length];
            while (null != entry) {
                if (n == entry.key) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return entry.value;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public Iterator iterator() {
        return new HashEnum(this.table);
    }

    public Iterator sortedIterator() {
        Object[] objectArray = new Entry[this.size()];
        Iterator iterator = this.entries();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = (Entry)iterator.next();
            ++n;
        }
        Arrays.sort(objectArray);
        return new EntryValuesIterator((Entry[])objectArray);
    }

    public Iterator sortedIterator(Comparator comparator) {
        Entry[] entryArray = new Entry[this.size()];
        Iterator iterator = this.entries();
        int n = 0;
        while (iterator.hasNext()) {
            entryArray[n] = (Entry)iterator.next();
            ++n;
        }
        Arrays.sort(entryArray, comparator);
        return new EntryValuesIterator(entryArray);
    }

    public Entry[] sortedEntry(Comparator comparator) {
        Entry[] entryArray = new Entry[this.size()];
        Iterator iterator = this.entries();
        int n = 0;
        while (iterator.hasNext()) {
            entryArray[n] = (Entry)iterator.next();
            ++n;
        }
        Arrays.sort(entryArray, comparator);
        return entryArray;
    }

    public HashKeyEnum keys() {
        return new HashKeyEnum(this.table);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            Entry[] entryArray2 = this.table;
            int n2 = (n & Integer.MAX_VALUE) % entryArray2.length;
            Entry entry = entryArray2[n2];
            while (null != entry) {
                if (entry.key == n) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(int n, Object object) {
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            Entry[] entryArray2 = this.table;
            int n2 = (n & Integer.MAX_VALUE) % entryArray2.length;
            Entry entry = entryArray2[n2];
            while (null != entry) {
                if (entry.key == n) {
                    entry.value = object;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return false;
                }
                entry = entry.next;
            }
            if (this.count + 1 >= this.threshold) {
                this.rehash();
                entryArray2 = this.table;
                n2 = (n & Integer.MAX_VALUE) % entryArray2.length;
            }
            entryArray2[n2] = new Entry(object, n, entryArray2[n2]);
            ++this.count;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        int n2 = PrimeFinder.nextPrime(n);
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * 0.75f);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        Entry[] entryArray = this.table;
        synchronized (this.table) {
            Entry[] entryArray2 = this.table;
            int n2 = (n & Integer.MAX_VALUE) % entryArray2.length;
            Entry entry = entryArray2[n2];
            Entry entry2 = null;
            while (entry != null) {
                if (entry.key == n) {
                    if (entry2 != null) {
                        entry2.next = entry.next;
                    } else {
                        entryArray2[n2] = entry.next;
                    }
                    --this.count;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return entry.value;
                }
                entry2 = entry;
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public int size() {
        return this.count;
    }

    public void dumpInformation() {
        int n = 0;
        int n2 = 0;
        int n3 = this.table.length;
        while (--n3 >= 0) {
            Entry entry = this.table[n3];
            int n4 = 0;
            while (null != entry) {
                ++n4;
                entry = entry.next;
            }
            if (0 == n4) {
                ++n;
                continue;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        LOG.debug("LoadFactor : 0.75");
        LOG.debug("Count : " + this.count);
        LOG.debug("Threshold : " + this.threshold);
        LOG.debug("Struct size : " + this.table.length);
        LOG.debug("Empty cells : " + n);
        LOG.debug("Max external reference : " + n2);
    }
}

