/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import com.adesoft.collections.Iterators;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MyLinkedList
extends AbstractCollection
implements Serializable {
    private static final long serialVersionUID = 520L;
    protected Entry head = null;
    protected Entry tail = null;
    private int size = 0;

    @Override
    public synchronized boolean add(Object object) {
        if (null == object) {
            throw new IllegalArgumentException("MyLinkedList.add() : cannot add null values");
        }
        this.tail = 0 == this.size++ ? (this.head = new Entry(object, null)) : (this.tail.next = new Entry(object, null));
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection collection) {
        if (!collection.isEmpty()) {
            for (Object e : collection) {
                if (null == e) {
                    throw new NullPointerException();
                }
                this.tail = null != this.tail ? (this.tail.next = new Entry(e, null)) : (this.head = new Entry(e, null));
                ++this.size;
            }
            return true;
        }
        return false;
    }

    public synchronized void addFirst(Object object) {
        if (null == object) {
            throw new IllegalArgumentException("MyLinkedList.add() : cannot add null values");
        }
        if (null == this.head) {
            this.tail = this.head = new Entry(object, null);
        } else {
            this.head = new Entry(object, this.head);
        }
        ++this.size;
    }

    @Override
    public synchronized void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    @Override
    public synchronized boolean contains(Object object) {
        Entry entry = this.head;
        while (null != entry) {
            if (entry.element.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public synchronized Object first() {
        if (null != this.head) {
            return this.head.element;
        }
        return null;
    }

    public Object get(int n) {
        if (n >= 0 && n < this.size()) {
            int n2 = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (n2 == n) {
                    return iterator.next();
                }
                iterator.next();
                ++n2;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public synchronized int indexOf(Object object) {
        int n = 0;
        Entry entry = this.head;
        while (null != entry) {
            if (entry.element.equals(object)) {
                return n;
            }
            entry = entry.next;
            ++n;
        }
        return -1;
    }

    @Override
    public final Iterator iterator() {
        return 0 != this.size() ? new ListItr(this) : Iterators.EMPTY_ITERATOR;
    }

    @Override
    public synchronized boolean remove(Object object) {
        Entry entry = null;
        Entry entry2 = this.head;
        while (null != entry2) {
            if (entry2.element.equals(object)) {
                if (null != entry) {
                    entry.next = entry2.next;
                    if (null == entry.next) {
                        this.tail = entry;
                    }
                } else {
                    this.head = entry2.next;
                    if (null == this.head) {
                        this.tail = null;
                    }
                }
                --this.size;
                return true;
            }
            entry = entry2;
            entry2 = entry2.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MyLinkedList) {
            MyLinkedList myLinkedList = (MyLinkedList)object;
            if (this.size() == myLinkedList.size()) {
                Entry entry = this.head;
                for (Entry entry2 = myLinkedList.head; null != entry && null != entry2; entry = entry.next(), entry2 = entry2.next()) {
                    Object object2 = entry.value();
                    Object object3 = entry2.value();
                    if ((null == object2 || null == object3) && object2 != object3) {
                        return false;
                    }
                    if (object2 == object3 || object2.equals(object3)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public synchronized void addTo(Collection collection) {
        for (Entry entry = this.head; null != entry; entry = entry.next()) {
            collection.add(entry.value());
        }
    }

    public MyLinkedList getCopy() {
        MyLinkedList myLinkedList = new MyLinkedList();
        myLinkedList.head = this.head;
        myLinkedList.tail = this.tail;
        myLinkedList.size = this.size;
        return myLinkedList;
    }

    private static final class ListItr
    implements Iterator {
        private final MyLinkedList list;
        private Entry current;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ListItr(MyLinkedList myLinkedList) {
            MyLinkedList myLinkedList2 = myLinkedList;
            synchronized (myLinkedList2) {
                this.list = myLinkedList;
                this.current = this.list.head;
            }
        }

        @Override
        public boolean hasNext() {
            return null != this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            if (null == this.current) {
                throw new NoSuchElementException();
            }
            MyLinkedList myLinkedList = this.list;
            synchronized (myLinkedList) {
                Object object = this.current.element;
                this.current = this.current.next;
                return object;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected static final class Entry
    implements Serializable {
        private static final long serialVersionUID = 520L;
        Object element;
        Entry next;

        protected Entry(Object object, Entry entry) {
            this.element = object;
            this.next = entry;
        }

        public Entry next() {
            return this.next;
        }

        public Object value() {
            return this.element;
        }
    }
}

