/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

public final class UniqueIds {
    private static final int ADDRESS_BITS_PER_UNIT = 6;
    private static final int BITS_PER_UNIT = 64;
    private static final int BIT_INDEX_MASK = 63;
    private int unitsInUse = 0;
    private long[] unit = new long[UniqueIds.unitIndex(63) + 1];
    private int maxValue = 0;
    private int minValue = 1;

    private static long bit(int n) {
        return 1L << (n & 0x3F);
    }

    private static int unitIndex(int n) {
        return n >> 6;
    }

    private void ensureCapacity(int n) {
        if (this.unit.length < n) {
            int n2 = Math.max(2 * this.unit.length, n);
            long[] lArray = new long[n2];
            System.arraycopy(this.unit, 0, lArray, 0, this.unitsInUse);
            this.unit = lArray;
        }
    }

    public synchronized void useId(int n) {
        if (n < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(n));
        }
        if (null != this.unit) {
            int n2 = UniqueIds.unitIndex(n);
            int n3 = n2 + 1;
            if (this.unitsInUse < n3) {
                this.ensureCapacity(n3);
                int n4 = n2;
                this.unit[n4] = this.unit[n4] | UniqueIds.bit(n);
                this.unitsInUse = n3;
            } else {
                int n5 = n2;
                this.unit[n5] = this.unit[n5] | UniqueIds.bit(n);
            }
        }
        if (n > this.maxValue) {
            this.maxValue = n;
        }
    }

    public synchronized int getNextId() {
        if (null == this.unit) {
            return ++this.maxValue;
        }
        int n = this.minValue;
        while (true) {
            int n2;
            if ((n2 = UniqueIds.unitIndex(n)) >= this.unitsInUse || 0L == (this.unit[n2] & UniqueIds.bit(n))) {
                int n3 = n2 + 1;
                if (this.unitsInUse < n3) {
                    this.ensureCapacity(n3);
                    int n4 = n2;
                    this.unit[n4] = this.unit[n4] | UniqueIds.bit(n);
                    this.unitsInUse = n3;
                } else {
                    int n5 = n2;
                    this.unit[n5] = this.unit[n5] | UniqueIds.bit(n);
                }
                if (n > this.maxValue) {
                    this.maxValue = n;
                    this.unit = null;
                }
                if (n > this.minValue) {
                    this.minValue = n;
                }
                return n;
            }
            ++n;
        }
    }
}

