/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.doc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public final class ReadCodes {
    public static final String BEGIN = "$BEGIN$ ";
    public static final String END = "$END$ ";
    private final String filename;
    private final Map codes = new TreeMap();

    public ReadCodes(String string) throws IOException, ParseException {
        this.filename = string;
        this.initialize();
    }

    public Map getCodes() {
        return Collections.unmodifiableMap(this.codes);
    }

    public String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws IOException, ParseException {
        TreeSet<String> treeSet = new TreeSet<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFilename()));){
            String string;
            while (null != (string = bufferedReader.readLine())) {
                Object object;
                int n = string.indexOf(BEGIN);
                if (-1 != n) {
                    object = string.substring(n + BEGIN.length()).trim();
                    if (treeSet.add((String)object)) continue;
                    throw new ParseException((String)object, 0);
                }
                n = string.indexOf(END);
                if (-1 != n) {
                    object = string.substring(n + END.length()).trim();
                    if (treeSet.remove(object)) continue;
                    throw new ParseException((String)object, 0);
                }
                if (treeSet.isEmpty()) continue;
                for (String string2 : treeSet) {
                    List<String> list;
                    if (this.codes.containsKey(string2)) {
                        list = (List)this.codes.get(string2);
                        list.add(string);
                        continue;
                    }
                    list = new ArrayList<String>();
                    list.add(string);
                    this.codes.put(string2, list);
                    System.out.println("Code fragment <" + string2 + ">");
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            ReadCodes readCodes = new ReadCodes("D:" + File.separator + "Public" + File.separator + "code.txt");
            Map map = readCodes.getCodes();
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                System.out.println(string);
                for (String string2 : list) {
                    System.out.println(string2);
                }
                System.out.println();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

