/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.img;

import com.adesoft.log.Category;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.List;
import javax.swing.ImageIcon;

public final class ImageUtil {
    private static final Category LOG = Category.getInstance("com.adesoft.img.ImageUtil");

    private ImageUtil() {
    }

    public static Image getImage(String string) {
        try {
            return Toolkit.getDefaultToolkit().createImage(ImageUtil.class.getResource(string));
        }
        catch (Exception exception) {
            LOG.error("Error trying to load image " + string + " (" + exception + ")");
            return null;
        }
    }

    public static Image[] getImages(List list) {
        int n = list.size();
        Image[] imageArray = new Image[n];
        for (int i = 0; i < n; ++i) {
            String string = (String)list.get(i);
            try {
                imageArray[i] = Toolkit.getDefaultToolkit().createImage(ImageUtil.class.getResource(string));
                continue;
            }
            catch (Exception exception) {
                LOG.error("Error trying to load image " + string + " (" + exception + ")");
            }
        }
        return imageArray;
    }

    public static ImageIcon loadIcon(String string) {
        try {
            return new ImageIcon(ImageUtil.class.getResource(string));
        }
        catch (Exception exception) {
            LOG.error("Error trying to load image " + string + " (" + exception + ")");
            return null;
        }
    }
}

