/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.img;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;

public final class Scatters {
    private static final int STEP = 4;
    private static Scatters instance;
    private final Map scatters = new HashMap();

    private Scatters() {
    }

    public static synchronized Scatters getInstance() {
        if (null == instance) {
            instance = new Scatters();
        }
        return instance;
    }

    private static final void drawScatter(Graphics2D graphics2D, int n, int n2, Color color, Color color2) {
        graphics2D.setColor(color);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(color2);
        int n3 = n + n2 - 1;
        for (int i = 4; i <= n3; i += 4) {
            int n4 = i > n2 ? i - n2 : 0;
            int n5 = i > n2 ? n2 : i;
            int n6 = i > n ? n : i;
            int n7 = i > n ? i - n : 0;
            graphics2D.drawLine(n4, n5, n6, n7);
            graphics2D.drawLine(n4 + 1, n5, n6 + 1, n7);
        }
    }

    public synchronized Paint getScatter(Color color, Color color2, Component component) {
        Paint paint = (Paint)this.scatters.get(color2);
        if (null == paint) {
            BufferedImage bufferedImage = new BufferedImage(16, 16, 1);
            Scatters.drawScatter((Graphics2D)bufferedImage.getGraphics(), 16, 16, color, color2);
            paint = new TexturePaint(bufferedImage.getSubimage(4, 4, 8, 8), new Rectangle(0, 0, 8, 8));
            this.scatters.put(color2, paint);
        }
        return paint;
    }
}

