/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;

public abstract class ConstraintLayout
implements LayoutManager2 {
    protected static final int PREFERRED = 0;
    protected static final int MINIMUM = 1;
    protected static final int MAXIMUM = 2;
    protected int hMargin = 0;
    protected int vMargin = 0;
    private Hashtable constraints;
    protected boolean includeInvisible = false;

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.setConstraint(component, string);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        this.setConstraint(component, object);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        if (this.constraints != null) {
            this.constraints.remove(component);
        }
    }

    public void setConstraint(Component component, Object object) {
        if (object != null) {
            if (this.constraints == null) {
                this.constraints = new Hashtable();
            }
            this.constraints.put(component, object);
        } else if (this.constraints != null) {
            this.constraints.remove(component);
        }
    }

    public Object getConstraint(Component component) {
        if (this.constraints != null) {
            return this.constraints.get(component);
        }
        return null;
    }

    public void setIncludeInvisible(boolean bl) {
        this.includeInvisible = bl;
    }

    public boolean getIncludeInvisible() {
        return this.includeInvisible;
    }

    protected boolean includeComponent(Component component) {
        return this.includeInvisible || component.isVisible();
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.calcLayoutSize(container, 1);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return this.calcLayoutSize(container, 2);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        return this.calcLayoutSize(container, 0);
    }

    public Dimension calcLayoutSize(Container container, int n) {
        Dimension dimension = new Dimension(0, 0);
        this.measureLayout(container, dimension, n);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + 2 * this.hMargin;
        dimension.height += insets.top + insets.bottom + 2 * this.vMargin;
        return dimension;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void layoutContainer(Container container) {
        this.measureLayout(container, null, 0);
    }

    public abstract void measureLayout(Container var1, Dimension var2, int var3);

    protected Dimension getComponentSize(Component component, int n) {
        if (n == 1) {
            return component.getMinimumSize();
        }
        if (n == 2) {
            return component.getMaximumSize();
        }
        return component.getPreferredSize();
    }
}

