/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public final class MyCardLayout
implements LayoutManager {
    @Override
    public void addLayoutComponent(String string, Component component) {
        if (string != null) {
            component.setName(string);
        }
        component.setVisible(component.getParent().getComponentCount() == 1);
    }

    @Override
    public void layoutContainer(Container container) {
        int n = container.getComponentCount();
        Insets insets = container.getInsets();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!component.isVisible()) continue;
            Rectangle rectangle = container.getBounds();
            int n2 = rectangle.width - (insets.left + insets.right);
            int n3 = rectangle.height - (insets.top + insets.bottom);
            component.setBounds(insets.left, insets.top, n2, n3);
            break;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n = container.getComponentCount();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        for (int i = 0; i < n; ++i) {
            Dimension dimension = container.getComponent(i).getMinimumSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height <= n3) continue;
            n3 = dimension.height;
        }
        return new Dimension(n2, n3);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = container.getComponentCount();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        for (int i = 0; i < n; ++i) {
            Dimension dimension = container.getComponent(i).getPreferredSize();
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            if (dimension.height <= n3) continue;
            n3 = dimension.height;
        }
        return new Dimension(n2, n3);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        Container container;
        if (component.isVisible() && (container = component.getParent()).getComponentCount() > 0) {
            container.getComponent(0).setVisible(true);
        }
    }
}

