/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import java.text.NumberFormat;
import java.util.Calendar;

final class LogBuffer {
    private final Calendar calendar = Calendar.getInstance();
    private char[] value;
    private int count;
    private static final char[][] digits2 = LogBuffer.initDigits(100, 2);
    private static final char[][] digits3 = LogBuffer.initDigits(1000, 3);
    private static final char[][] digits4 = LogBuffer.initDigits(10000, 4);

    public LogBuffer() {
        this(16);
    }

    public LogBuffer(int n) {
        this.value = new char[n];
    }

    public int length() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    private void ensureCapacity(int n) {
        if (n > this.value.length) {
            int n2 = (this.value.length + 1) * 2;
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            } else if (n > n2) {
                n2 = n;
            }
            char[] cArray = new char[n2];
            System.arraycopy(this.value, 0, cArray, 0, this.count);
            this.value = cArray;
        }
    }

    public void append(String string) {
        int n = string.length();
        int n2 = this.count + n;
        this.ensureCapacity(n2);
        string.getChars(0, n, this.value, this.count);
        this.count = n2;
    }

    public void append(char c) {
        this.ensureCapacity(this.count + 1);
        this.value[this.count++] = c;
    }

    public String toString() {
        return new String(this.value, 0, this.count);
    }

    private static char[][] initDigits(int n, int n2) {
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumIntegerDigits(n2);
        numberFormat.setMaximumIntegerDigits(n2);
        char[][] cArrayArray = new char[n][];
        for (int i = 0; i < n; ++i) {
            cArrayArray[i] = numberFormat.format(i).toCharArray();
        }
        return cArrayArray;
    }

    public void appendCurrentDate() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        this.ensureCapacity(this.count + 23);
        char[] cArray = digits2[this.calendar.get(5)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = 47;
        cArray = digits2[1 + this.calendar.get(2)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = 47;
        cArray = digits4[this.calendar.get(1)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = cArray[2];
        this.value[this.count++] = cArray[3];
        this.value[this.count++] = 32;
        cArray = digits2[this.calendar.get(11)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = 58;
        cArray = digits2[this.calendar.get(12)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = 58;
        cArray = digits2[this.calendar.get(13)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = 46;
        cArray = digits3[this.calendar.get(14)];
        this.value[this.count++] = cArray[0];
        this.value[this.count++] = cArray[1];
        this.value[this.count++] = cArray[2];
    }
}

