/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.misc;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class Enum
implements Comparable,
Serializable {
    private static final long serialVersionUID = 520L;
    private static final Map sequencePerClass = new HashMap();
    private static final Map instancesPerClass = new HashMap();
    private static final Map instancesPerNameAndClass = new HashMap();
    private final transient int sequence;
    private final String name;

    protected Enum(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.name = string.intern();
        this.checkAndAddInstance();
        this.sequence = Enum.getNextSequence(this.getBaseClass());
    }

    private void checkAndAddInstance() {
        this.checkBaseClass();
        Map map = Enum.getInstancesPerName(this.getBaseClass());
        if (map.get(this.name) != null) {
            throw new IllegalArgumentException(this.name);
        }
        map.put(this.name, this);
        Enum.getInstances(this.getBaseClass()).add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getInstancesPerName(Class clazz) {
        IdentityHashMap identityHashMap = null;
        Map map = instancesPerNameAndClass;
        synchronized (map) {
            identityHashMap = (IdentityHashMap)instancesPerNameAndClass.get(clazz);
            if (identityHashMap == null) {
                identityHashMap = new IdentityHashMap();
                instancesPerNameAndClass.put(clazz, identityHashMap);
            }
        }
        return identityHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getInstances(Class clazz) {
        Enum.checkClass(clazz);
        ArrayList arrayList = null;
        Map map = instancesPerClass;
        synchronized (map) {
            arrayList = (ArrayList)instancesPerClass.get(clazz);
            if (arrayList == null) {
                arrayList = new ArrayList();
                instancesPerClass.put(clazz, arrayList);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextSequence(Class clazz) {
        Integer n = null;
        Map map = sequencePerClass;
        synchronized (map) {
            n = (Integer)sequencePerClass.get(clazz);
            n = n == null ? new Integer(0) : new Integer(n + 1);
            sequencePerClass.put(clazz, n);
        }
        return n;
    }

    public static Enum get(Class clazz, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        Enum.checkClass(clazz);
        return (Enum)Enum.getInstancesPerName(clazz).get(string.intern());
    }

    private static void checkClass(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!Enum.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("clazz: " + clazz.getName());
        }
    }

    private void checkBaseClass() {
        Class clazz = this.getBaseClass();
        Enum.checkClass(clazz);
        if (!clazz.isAssignableFrom(this.getClass())) {
            throw new IllegalArgumentException("clazz: " + clazz.getName());
        }
    }

    private boolean compareClasses(Object object) {
        Class clazz = this.getBaseClass();
        return clazz.isAssignableFrom(object.getClass()) && clazz.isAssignableFrom(((Enum)object).getBaseClass());
    }

    public final String getName() {
        return this.name;
    }

    public final int getSequence() {
        return this.sequence;
    }

    protected Class getBaseClass() {
        return this.getClass();
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        if (!this.compareClasses(object)) {
            throw new ClassCastException(object.getClass().getName());
        }
        int n = ((Enum)object).sequence;
        return this.sequence == n ? 0 : (this.sequence > n ? 1 : -1);
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected final Object readResolve() throws ObjectStreamException {
        Enum enum_ = (Enum)Enum.getInstancesPerName(this.getBaseClass()).get(this.name.intern());
        if (enum_ == null) {
            throw new InvalidObjectException(this.name);
        }
        return enum_;
    }
}

