/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.misc;

import com.adesoft.log.Category;
import com.adesoft.misc.HttpUrlParam;
import com.adesoft.misc.Util;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public final class HttpUtils {
    private static final Category LOG = Category.getInstance("com.adesoft.misc.HttpUtils");
    private static final int MAX_TRY = 3;

    public static final void post(HttpUrlParam httpUrlParam, Serializable serializable) {
        for (int i = 0; i < 3; ++i) {
            try {
                HttpUtils.executePost(httpUrlParam, serializable);
                break;
            }
            catch (IOException iOException) {
                LOG.error(iOException);
                continue;
            }
        }
    }

    public static final void post(HttpUrlParam httpUrlParam) {
        HttpUtils.post(httpUrlParam, 3, 0L);
    }

    public static final void post(HttpUrlParam httpUrlParam, int n, long l) {
        for (int i = 0; i < n; ++i) {
            try {
                HttpUtils.postImpl(httpUrlParam, false);
                break;
            }
            catch (IOException iOException) {
                LOG.error(iOException);
                if (l <= 0L) continue;
                Util.pause(l);
                continue;
            }
        }
    }

    public static final void postAndRead(HttpUrlParam httpUrlParam) {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 3; ++i) {
            try {
                HttpUtils.postImpl(httpUrlParam, true);
                break;
            }
            catch (IOException iOException) {
                LOG.error(iOException);
                continue;
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("post : " + (l2 - l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void postImpl(HttpUrlParam httpUrlParam, boolean bl) throws IOException {
        Closeable closeable;
        URL uRL = new URL(httpUrlParam.getUrl());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setDefaultUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        if (null != httpUrlParam.getParameters() && 0 != httpUrlParam.getParameters().length()) {
            closeable = new DataOutputStream(uRLConnection.getOutputStream());
            try {
                ((DataOutputStream)closeable).writeBytes(httpUrlParam.getParameters());
                ((DataOutputStream)closeable).flush();
            }
            finally {
                ((FilterOutputStream)closeable).close();
            }
        }
        closeable = new DataInputStream(uRLConnection.getInputStream());
        try {
            if (bl) {
                int n = 0;
                int n2 = 0;
                byte[] byArray = new byte[4096];
                while (-1 != (n2 = ((DataInputStream)closeable).read(byArray))) {
                    n += n2;
                }
            }
        }
        finally {
            ((FilterInputStream)closeable).close();
        }
    }

    private static final void executePost(HttpUrlParam httpUrlParam, Serializable serializable) throws IOException {
        URL uRL = new URL(httpUrlParam.getUrl());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setDefaultUseCaches(false);
        uRLConnection.setRequestProperty("Content-Type", "application/x-java-serialized-object");
        ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(uRLConnection.getOutputStream());
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        uRLConnection.getContentType();
    }

    public static final void putParams(Map map, String string) {
        String[] stringArray = string.split("\\&");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (0 == stringArray[i].trim().length() || -1 == (n = stringArray[i].indexOf(61)) || 0 == n) continue;
            String string2 = stringArray[i].substring(0, n).trim();
            String string3 = stringArray[i].substring(n + 1);
            map.put(string2, string3);
        }
    }
}

