/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.rmicallback;

import com.adesoft.rmi.DefaultSocketBehavior;
import com.adesoft.rmicallback.EndpointInfo;
import com.adesoft.rmicallback.SignallingChannel;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMISocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClientTwoWaySocketFactory
extends RMISocketFactory {
    private Map gatewayMap = Collections.synchronizedMap(new HashMap());
    private SignallingChannel channel;

    public void registerGateway(String string, int n, String string2, int n2) {
        this.gatewayMap.put(EndpointInfo.getEndpointString(string, n), new EndpointInfo(string2, n2));
    }

    public void establishSignallingChannel(String string, int n) throws IOException {
        this.channel = new SignallingChannel(string, n);
        this.registerGateway(this.channel.getDestinationAddress(), this.channel.getDestinationPort(), this.channel.getDirectAddress(), this.channel.getDirectPort());
        this.channel.start();
    }

    public EndpointInfo getDirectEndpoint(String string, int n) {
        EndpointInfo endpointInfo = (EndpointInfo)this.gatewayMap.get(EndpointInfo.getEndpointString(string, n));
        if (endpointInfo != null) {
            return endpointInfo;
        }
        return new EndpointInfo(string, n);
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException {
        EndpointInfo endpointInfo = this.getDirectEndpoint(string, n);
        Socket socket = new Socket(endpointInfo.getHost(), endpointInfo.getPort());
        DefaultSocketBehavior.applyClientBehavior(socket);
        return socket;
    }

    @Override
    public ServerSocket createServerSocket(int n) throws IOException {
        ServerSocket serverSocket = new ServerSocket(n);
        DefaultSocketBehavior.applyClientBehavior(serverSocket);
        if (this.channel != null) {
            this.channel.getOutputStream().writeInt(serverSocket.getLocalPort());
        }
        return serverSocket;
    }
}

