/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.script;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import com.adesoft.log.Category;
import java.io.IOException;
import java.util.Map;

public final class BeanShellScript {
    private static final Category LOG = Category.getInstance("com.adesoft.script.BeanShellScript");
    private static BeanShellScript instance;
    private Interpreter interpreter;

    private BeanShellScript() {
    }

    public static synchronized BeanShellScript getInstance() {
        if (null == instance) {
            instance = new BeanShellScript();
        }
        return instance;
    }

    private synchronized Interpreter getInterpreter() {
        if (null == this.interpreter) {
            this.interpreter = new Interpreter();
        }
        return this.interpreter;
    }

    private synchronized void resetInterpreter() {
        this.interpreter = null;
    }

    private void setParameters(Map map) throws EvalError {
        if (null != map) {
            Interpreter interpreter = this.getInterpreter();
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                Object v = entry.getValue();
                interpreter.set(string, v);
            }
        }
    }

    public synchronized void eval(String string, Map map) {
        try {
            this.resetInterpreter();
            this.setParameters(map);
            this.getInterpreter().eval(string);
        }
        catch (TargetError targetError) {
            LOG.error("Error in script: " + targetError.getTarget());
        }
        catch (EvalError evalError) {
            LOG.error("Script syntax error: " + (Object)((Object)evalError));
        }
        catch (Throwable throwable) {
            LOG.error("Unknow error in script: " + throwable);
        }
    }

    public void executeScript(String string, Map map) {
        try {
            this.resetInterpreter();
            this.setParameters(map);
            this.getInterpreter().source(string);
        }
        catch (TargetError targetError) {
            LOG.error("Error in script: " + targetError.getTarget());
        }
        catch (EvalError evalError) {
            LOG.error("Script syntax error: " + (Object)((Object)evalError));
        }
        catch (IOException iOException) {
            LOG.error("File not found: " + iOException);
        }
        catch (Throwable throwable) {
            LOG.error("Unknow error in script: " + throwable);
        }
    }
}

