/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.thread;

import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class BlockingQueue {
    private static final long serialVersionUID = 520L;
    private LinkedList elements = new LinkedList();
    private boolean closed = false;
    private int waiting_threads = 0;

    public synchronized void close() {
        this.closed = true;
        this.elements = null;
        this.notifyAll();
    }

    public synchronized Object dequeue() throws InterruptedException, Closed {
        if (this.closed) {
            throw new Closed();
        }
        try {
            if (this.elements.isEmpty()) {
                ++this.waiting_threads;
                while (this.elements.isEmpty()) {
                    this.wait();
                    if (!this.closed) continue;
                    --this.waiting_threads;
                    throw new Closed();
                }
                --this.waiting_threads;
            }
            return this.elements.removeFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new Error("Internal error (com.holub.asynch.Blocking_queue)");
        }
    }

    public synchronized void enqueue(Object object) throws Closed {
        if (this.closed) {
            throw new Closed();
        }
        this.elements.addLast(object);
        this.notifyAll();
    }

    public int waiting_threads() {
        return this.waiting_threads;
    }

    public static final class Closed
    extends RuntimeException {
        private static final long serialVersionUID = 520L;

        protected Closed() {
            super("Tried to access closed BlockingQueue");
        }
    }
}

