/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.thread;

import com.adesoft.log.Category;
import com.adesoft.thread.BlockingQueue;
import com.adesoft.thread.Command;
import com.adesoft.thread.RunnableEx;

public final class ThreadPool
extends ThreadGroup {
    private static final Category LOG = Category.getInstance("com.adesoft.thread.ThreadPool");
    protected final BlockingQueue pool = new BlockingQueue();
    protected int maximum_size;
    protected int pool_size;
    protected boolean has_closed = false;
    protected static int group_number = 0;
    protected static int thread_id = 0;
    protected static ThreadPool instance;

    public ThreadPool() {
        super("Thread_pool" + group_number++);
        this.maximum_size = 10;
    }

    public ThreadPool(int n, int n2) {
        super("Thread_pool" + group_number++);
        this.maximum_size = n2 > 0 ? n2 : Integer.MAX_VALUE;
        int n3 = this.pool_size = Math.min(n, this.maximum_size);
        while (--n3 >= 0) {
            new Pooled_thread().start();
        }
    }

    public synchronized void close() {
        this.has_closed = true;
        this.pool.close();
    }

    public void execute(Command command) throws Closed {
        this.execute(command, null);
    }

    public synchronized void execute(Command command, Object object) throws Closed {
        this.executeAction(new RunnableEx(command, object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeAction(Object object) throws Closed {
        LOG.debug("Execute a threaded action...");
        if (this.has_closed) {
            throw new Closed();
        }
        if (this.pool_size < this.maximum_size && this.pool.waiting_threads() == 0) {
            BlockingQueue blockingQueue = this.pool;
            synchronized (blockingQueue) {
                if (this.pool_size < this.maximum_size && this.pool.waiting_threads() == 0) {
                    ++this.pool_size;
                    LOG.debug("Create a new pooled thread");
                    new Pooled_thread().start();
                }
                this.pool.enqueue(object);
            }
        } else {
            this.pool.enqueue(object);
        }
    }

    public static synchronized ThreadPool getInstance() {
        if (null == instance) {
            instance = new ThreadPool(1, 5);
        }
        return instance;
    }

    public static final class Closed
    extends RuntimeException {
        private static final long serialVersionUID = 520L;

        Closed() {
            super("Tried to execute operation on a closed ThreadPool");
        }
    }

    private final class Pooled_thread
    extends Thread {
        public Pooled_thread() {
            super((ThreadGroup)ThreadPool.this, "T" + thread_id);
        }

        @Override
        public void run() {
            try {
                while (!ThreadPool.this.has_closed) {
                    RunnableEx runnableEx = (RunnableEx)ThreadPool.this.pool.dequeue();
                    this.setName(runnableEx.getName());
                    runnableEx.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BlockingQueue.Closed closed) {
                // empty catch block
            }
        }
    }
}

