/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.tokenparser;

import com.adesoft.tokenparser.ParseTokenException;
import com.adesoft.tokenparser.ReplaceAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class TokenParser {
    private static final char DEFAULT_SYMBOL = '#';
    private final char symbol;
    private final Map actions;
    private ReplaceAction defaultAction;

    public TokenParser() {
        this('#');
    }

    public TokenParser(char c) {
        this.symbol = c;
        this.actions = new HashMap();
    }

    public TokenParser(char c, Map map) {
        this.symbol = c;
        this.actions = map;
        Iterator<Object> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new IllegalArgumentException("Key is not a String");
        }
        iterator = map.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof ReplaceAction) continue;
            throw new IllegalArgumentException("Value is not a ReplaceAction");
        }
    }

    public TokenParser(Map map) {
        this('#', map);
    }

    public ReplaceAction getAction(String string) {
        ReplaceAction replaceAction = (ReplaceAction)this.actions.get(string);
        if (null == replaceAction) {
            return this.defaultAction;
        }
        return replaceAction;
    }

    private final char getSymbol() {
        return this.symbol;
    }

    public String parse(BufferedReader bufferedReader) throws ParseTokenException, IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        while (null != (string = bufferedReader.readLine())) {
            stringBuffer.append(this.parse(string));
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public String parse(String string) throws ParseTokenException {
        int n = string.length();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer((int)((double)n * 1.1));
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (this.getSymbol() != c) {
                if (!bl) {
                    stringBuffer2.append(c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (!bl) {
                bl = true;
                stringBuffer.setLength(0);
                continue;
            }
            bl = false;
            if (0 != stringBuffer.length()) {
                ReplaceAction replaceAction = this.getAction(stringBuffer.toString());
                if (null != replaceAction) {
                    String string2 = replaceAction.getValue(stringBuffer.toString());
                    stringBuffer2.append(string2);
                    continue;
                }
                throw new ParseTokenException(stringBuffer.toString());
            }
            stringBuffer2.append(this.getSymbol());
        }
        if (bl) {
            throw new ParseTokenException(stringBuffer.toString());
        }
        return stringBuffer2.toString();
    }

    public void register(String string, ReplaceAction replaceAction) {
        this.actions.put(string, replaceAction);
    }

    public void registerDefaultAction(ReplaceAction replaceAction) {
        this.defaultAction = replaceAction;
    }
}

