/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.arrays;

import java.io.Serializable;

public final class ByteArray
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULTSIZE = 10;
    private int count = 0;
    private byte[] elements;

    public ByteArray() {
        this(10);
    }

    public ByteArray(int n) {
        this.elements = new byte[n];
    }

    public void add(byte[] byArray, int n, int n2) {
        int n3 = this.elements.length;
        if (this.count + n2 >= n3) {
            byte[] byArray2 = new byte[n2 + n3 * 3 / 2];
            System.arraycopy(this.elements, 0, byArray2, 0, n3);
            this.elements = byArray2;
        }
        System.arraycopy(byArray, n, this.elements, this.count, n2);
        this.count += n2;
    }

    public void add(byte by) {
        int n = this.elements.length;
        if (this.count + 1 >= n) {
            byte[] byArray = new byte[1 + n * 3 / 2];
            System.arraycopy(this.elements, 0, byArray, 0, n);
            this.elements = byArray;
        }
        this.elements[this.count++] = by;
    }

    public byte get(int n) {
        if (n < 0 || n >= this.count) {
            throw new IllegalArgumentException("ByteArray.get()");
        }
        return this.elements[n];
    }

    public byte[] getValues() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.elements, 0, byArray, 0, this.count);
        return byArray;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public void set(int n, byte by) {
        if (n < 0 || n >= this.count) {
            throw new IllegalArgumentException("ByteArray.set()");
        }
        this.elements[n] = by;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        for (int i = 0; i < this.count; ++i) {
            if (0 != i) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.elements[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public void clear() {
        this.count = 0;
    }
}

