/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import com.adesoft.log.Category;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IntHashMap
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final Category LOG = Category.getInstance("com.adesoft.util.IntHashMap");
    private final Map map;

    public IntHashMap() {
        this.map = new HashMap();
    }

    public IntHashMap(int n) {
        this.map = new HashMap(n);
    }

    public IntHashMap(IntHashMap intHashMap) {
        this.map = new HashMap(intHashMap.map);
    }

    public int add(Object object, int n) {
        int n2 = n;
        Object v = this.map.get(object);
        if (null == v) {
            this.map.put(object, new IntEntry(n2));
        } else {
            ((IntEntry)v).setValue(n2 += ((IntEntry)v).getValue());
        }
        return n2;
    }

    public void clear() {
        this.map.clear();
    }

    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    public Iterator entries() {
        return this.map.entrySet().iterator();
    }

    public void dump() {
        for (Map.Entry entry : this.map.entrySet()) {
            String string = entry.getKey().toString();
            int n = ((IntEntry)entry.getValue()).getValue();
            LOG.debug(string + " - " + n);
        }
    }

    public int get(Object object) {
        Object v = this.map.get(object);
        if (null != v) {
            return ((IntEntry)v).getValue();
        }
        return -1;
    }

    protected IntEntry getEntry(Object object) {
        Object v = this.map.get(object);
        if (null != v) {
            return (IntEntry)v;
        }
        return null;
    }

    public List keys() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.map.entrySet()) {
            IntEntry intEntry = (IntEntry)entry.getValue();
            if (0 == intEntry.getValue()) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public List allKeys() {
        ArrayList arrayList = new ArrayList();
        for (Map.Entry entry : this.map.entrySet()) {
            IntEntry intEntry = (IntEntry)entry.getValue();
            if (-1 == intEntry.getValue()) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public void putAll(IntHashMap intHashMap) {
        this.map.putAll(intHashMap.map);
    }

    public void remove(Object object) {
        this.map.remove(object);
    }

    public IntEntry set(Object object, int n) {
        IntEntry intEntry = (IntEntry)this.map.get(object);
        if (null == intEntry) {
            intEntry = new IntEntry(n);
            this.map.put(object, intEntry);
        } else {
            intEntry.setValue(n);
        }
        return intEntry;
    }

    public int size() {
        return this.map.size();
    }

    public static final class IntEntry
    implements Serializable {
        private static final long serialVersionUID = 520L;
        private int value;

        protected IntEntry(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int n) {
            this.value = n;
        }
    }
}

