/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public final class ListUnique
extends ArrayList {
    private static final long serialVersionUID = 520L;
    private HashSet set = new HashSet();

    public ListUnique() {
    }

    public ListUnique(int n) {
        super(n);
    }

    public ListUnique(Collection collection) {
        this.set.addAll(collection);
        this.ensureCapacity(this.set.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            super.add(iterator.next());
        }
    }

    @Override
    public boolean add(Object object) {
        if (this.set.add(object)) {
            return super.add(object);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection collection) {
        int n = this.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return this.size() != n;
    }

    public boolean addAll(Object[] objectArray) {
        int n = this.size();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            this.add(objectArray[i]);
        }
        return this.size() != n;
    }

    @Override
    public boolean retainAll(Collection collection) {
        int n = this.size();
        this.set.retainAll(collection);
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            if (this.set.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.size() != n;
    }

    @Override
    public boolean removeAll(Collection collection) {
        int n = this.size();
        this.set.removeAll(collection);
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            if (this.set.contains(iterator.next())) continue;
            iterator.remove();
        }
        return this.size() != n;
    }

    @Override
    public boolean remove(Object object) {
        if (this.set.remove(object)) {
            return super.remove(object);
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return this.set.contains(object);
    }

    @Override
    public void clear() {
        this.set.clear();
        super.clear();
    }
}

