/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import com.adesoft.collections.Entry;
import com.adesoft.collections.EntryValuesIterator;
import com.adesoft.collections.HashEntryEnum;
import com.adesoft.collections.HashEnum;
import com.adesoft.collections.HashKeyEnum;
import com.adesoft.collections.PrimeFinder;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;

public class MyHashTableNotSynchronized
implements Serializable {
    private static final long serialVersionUID = 520L;
    private static final int DEFAULT_SIZE = 11;
    private static final float DEFAULT_LOAD = 0.75f;
    private Entry[] table;
    private int count;
    private int threshold;

    public MyHashTableNotSynchronized() {
        this(11);
    }

    public MyHashTableNotSynchronized(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity : " + n);
        }
        if (0 == n) {
            n = 1;
        }
        this.table = new Entry[n];
        this.count = 0;
        this.threshold = (int)((float)n * 0.75f);
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        int n = 0;
        int n2 = this.table.length;
        while (--n2 >= 0) {
            Entry entry = this.table[n2];
            while (null != entry) {
                objectArray[n++] = entry.getValue();
                entry = entry.next;
            }
        }
        return objectArray;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        int n = 0;
        int n2 = this.table.length;
        while (--n2 >= 0) {
            Entry entry = this.table[n2];
            while (null != entry) {
                objectArray[n++] = entry.getValue();
                entry = entry.next;
            }
        }
        return objectArray;
    }

    public void clear() {
        if (this.count > 0) {
            this.count = 0;
            this.table = new Entry[this.table.length];
        }
    }

    public Iterator entries() {
        return new HashEntryEnum(this.table);
    }

    public final Object get(int n) {
        Entry entry = this.table[(n & Integer.MAX_VALUE) % this.table.length];
        while (null != entry) {
            if (n == entry.key) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return 0 == this.count;
    }

    public Iterator iterator() {
        return new HashEnum(this.table);
    }

    public Iterator sortedIterator() {
        Object[] objectArray = new Entry[this.size()];
        Iterator iterator = this.entries();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = (Entry)iterator.next();
            ++n;
        }
        Arrays.sort(objectArray);
        return new EntryValuesIterator((Entry[])objectArray);
    }

    public HashKeyEnum keys() {
        return new HashKeyEnum(this.table);
    }

    public boolean containsValue(Object object) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (null != entry) {
            if (entry.key == n) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean put(int n, Object object) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (null != entry) {
            if (entry.key == n) {
                entry.value = object;
                return false;
            }
            entry = entry.next;
        }
        if (this.count + 1 >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = new Entry(object, n, entryArray[n2]);
        ++this.count;
        return true;
    }

    private void rehash() {
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        int n2 = PrimeFinder.nextPrime(n);
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (int)((float)n2 * 0.75f);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.key & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    public Object remove(int n) {
        Entry[] entryArray = this.table;
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.key == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                return entry.value;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }
}

