/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.collections;

import com.adesoft.collections.Iterators;
import java.io.Serializable;
import java.util.Iterator;

public class TightList
implements Serializable {
    private static final long serialVersionUID = 520L;
    private Object[] obj;

    public TightList() {
        this.obj = null;
    }

    private TightList(Object[] objectArray) {
        this.obj = objectArray;
    }

    public void clear() {
        this.obj = null;
    }

    public int size() {
        return null != this.obj ? this.obj.length : 0;
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    public Object first() {
        if (this.size() < 1) {
            return null;
        }
        return this.obj[0];
    }

    public Object get(int n) {
        return this.obj[n];
    }

    public void add(Object object) {
        if (null == object) {
            throw new IllegalArgumentException("TightList.add : do not support null values");
        }
        if (null != this.obj) {
            Object[] objectArray = this.obj;
            int n = objectArray.length;
            Object[] objectArray2 = new Object[n + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, n);
            objectArray2[n] = object;
            this.obj = objectArray2;
        } else {
            this.obj = new Object[1];
            this.obj[0] = object;
        }
    }

    public void remove(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(object)) continue;
            if (1 == this.obj.length) {
                this.obj = null;
            } else {
                Object[] objectArray = this.obj;
                int n = objectArray.length;
                Object[] objectArray2 = new Object[n - 1];
                int n2 = 0;
                for (int j = 0; j < n; ++j) {
                    if (j == i) continue;
                    objectArray2[n2++] = objectArray[j];
                }
                this.obj = objectArray2;
            }
            return;
        }
    }

    public boolean contains(Object object) {
        if (null != this.obj) {
            for (int i = this.obj.length - 1; i >= 0; --i) {
                if (!this.obj[i].equals(object)) continue;
                return true;
            }
        }
        return false;
    }

    public int indexOf(Object object) {
        if (null != this.obj) {
            for (int i = this.obj.length - 1; i >= 0; --i) {
                if (!this.obj[i].equals(object)) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TightList) {
            TightList tightList = (TightList)object;
            if (null == this.obj && null == tightList.obj) {
                return true;
            }
            if (this.size() == tightList.size()) {
                for (int i = this.size() - 1; i >= 0; --i) {
                    if (this.get(i).equals(tightList.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public Iterator iterator() {
        return null != this.obj ? new TightListIterator(this.obj) : Iterators.EMPTY_ITERATOR;
    }

    public TightList copy() {
        if (null == this.obj) {
            return new TightList();
        }
        return new TightList((Object[])this.obj.clone());
    }

    private static final class TightListIterator
    implements Iterator {
        private int i;
        private final Object[] o;

        public TightListIterator(Object[] objectArray) {
            this.o = objectArray;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.o.length;
        }

        public Object next() {
            return this.o[this.i++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

