/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.img;

import com.adesoft.img.DebugObserver;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public final class IconModifier {
    private static IconModifier instance;
    private static final Color COLOR_HIGHLIGHT;
    private final ImageObserver observer = new DebugObserver();
    private final Map icons = new HashMap();
    private final Map highlighted = new HashMap();

    private IconModifier() {
    }

    public static synchronized IconModifier getInstance() {
        if (null == instance) {
            instance = new IconModifier();
        }
        return instance;
    }

    private static ImageIcon _highlight(ImageIcon imageIcon, ImageObserver imageObserver) {
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(COLOR_HIGHLIGHT);
        graphics.fillRect(0, 0, n, n2);
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageObserver);
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
        return imageIcon2;
    }

    private ImageIcon store(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = IconModifier._highlight(imageIcon, this.observer);
        this.highlighted.put(imageIcon, imageIcon2);
        this.highlighted.put(imageIcon2, imageIcon2);
        this.icons.put(imageIcon2, imageIcon);
        this.icons.put(imageIcon, imageIcon);
        return imageIcon2;
    }

    public ImageIcon highlightIcon(ImageIcon imageIcon, boolean bl) {
        if (bl) {
            ImageIcon imageIcon2 = (ImageIcon)this.highlighted.get(imageIcon);
            if (null == imageIcon2) {
                imageIcon2 = this.store(imageIcon);
            }
            return imageIcon2;
        }
        ImageIcon imageIcon3 = (ImageIcon)this.icons.get(imageIcon);
        if (null == imageIcon3) {
            this.store(imageIcon);
            imageIcon3 = imageIcon;
        }
        return imageIcon3;
    }

    static {
        COLOR_HIGHLIGHT = new Color(255, 70, 70);
    }
}

