/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.layouts;

import com.adesoft.layouts.TableLayoutConstants;
import com.adesoft.layouts.TableLayoutConstraints;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;

public class TableLayout
implements LayoutManager2,
Serializable,
TableLayoutConstants {
    private static final long serialVersionUID = 520L;
    private static final double[][] defaultSize = new double[][]{new double[0], new double[0]};
    protected double[] columnSpec;
    protected double[] rowSpec;
    protected int[] columnSize;
    protected int[] rowSize;
    protected int[] columnOffset;
    protected int[] rowOffset;
    protected LinkedList list;
    protected boolean dirty;
    protected int oldWidth;
    protected int oldHeight;

    public TableLayout() {
        this(defaultSize);
    }

    public TableLayout(double[][] dArray) {
        if (dArray != null && dArray.length == 2) {
            int n;
            double[] dArray2 = dArray[0];
            double[] dArray3 = dArray[1];
            this.columnSpec = new double[dArray2.length];
            this.rowSpec = new double[dArray3.length];
            System.arraycopy(dArray2, 0, this.columnSpec, 0, this.columnSpec.length);
            System.arraycopy(dArray3, 0, this.rowSpec, 0, this.rowSpec.length);
            for (n = 0; n < this.columnSpec.length; ++n) {
                if (!(this.columnSpec[n] < 0.0) || this.columnSpec[n] == -1.0 || this.columnSpec[n] == -2.0 || this.columnSpec[n] == -3.0) continue;
                this.columnSpec[n] = 0.0;
            }
            for (n = 0; n < this.rowSpec.length; ++n) {
                if (!(this.rowSpec[n] < 0.0) || this.rowSpec[n] == -1.0 || this.rowSpec[n] == -2.0 || this.rowSpec[n] == -3.0) continue;
                this.rowSpec[n] = 0.0;
            }
        } else {
            double[] dArray4 = new double[]{-1.0};
            double[] dArray5 = new double[]{-1.0};
            this.setColumn(dArray4);
            this.setRow(dArray5);
        }
        this.list = new LinkedList();
        this.dirty = true;
    }

    public TableLayoutConstraints getConstraints(Component component) {
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            return new TableLayoutConstraints(entry.col1, entry.row1, entry.col2, entry.row2, entry.hAlign, entry.vAlign);
        }
        return null;
    }

    public void setConstraints(Component component, TableLayoutConstraints tableLayoutConstraints) {
        if (component == null) {
            throw new IllegalArgumentException("Parameter component cannot be null.");
        }
        if (tableLayoutConstraints == null) {
            throw new IllegalArgumentException("Parameter constraint cannot be null.");
        }
        ListIterator<Entry> listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.component != component) continue;
            listIterator.set(new Entry(component, tableLayoutConstraints));
        }
    }

    public void setColumn(double[] dArray) {
        this.columnSpec = new double[dArray.length];
        System.arraycopy(dArray, 0, this.columnSpec, 0, this.columnSpec.length);
        for (int i = 0; i < this.columnSpec.length; ++i) {
            if (!(this.columnSpec[i] < 0.0) || this.columnSpec[i] == -1.0 || this.columnSpec[i] == -2.0 || this.columnSpec[i] == -3.0) continue;
            this.columnSpec[i] = 0.0;
        }
        this.dirty = true;
    }

    public void setRow(double[] dArray) {
        this.rowSpec = new double[dArray.length];
        System.arraycopy(dArray, 0, this.rowSpec, 0, this.rowSpec.length);
        for (int i = 0; i < this.rowSpec.length; ++i) {
            if (!(this.rowSpec[i] < 0.0) || this.rowSpec[i] == -1.0 || this.rowSpec[i] == -2.0 || this.rowSpec[i] == -3.0) continue;
            this.rowSpec[i] = 0.0;
        }
        this.dirty = true;
    }

    public void setColumn(int n, double d) {
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        this.columnSpec[n] = d;
        this.dirty = true;
    }

    public void setRow(int n, double d) {
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        this.rowSpec[n] = d;
        this.dirty = true;
    }

    public double[] getColumn() {
        double[] dArray = new double[this.columnSpec.length];
        System.arraycopy(this.columnSpec, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double[] getRow() {
        double[] dArray = new double[this.rowSpec.length];
        System.arraycopy(this.rowSpec, 0, dArray, 0, dArray.length);
        return dArray;
    }

    public double getColumn(int n) {
        return this.columnSpec[n];
    }

    public double getRow(int n) {
        return this.rowSpec[n];
    }

    public int getNumColumn() {
        return this.columnSpec.length;
    }

    public int getNumRow() {
        return this.rowSpec.length;
    }

    public void insertColumn(int n, double d) {
        if (n < 0 || n > this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + this.columnSpec.length + "].");
        }
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        double[] dArray = new double[this.columnSpec.length + 1];
        System.arraycopy(this.columnSpec, 0, dArray, 0, n);
        System.arraycopy(this.columnSpec, n, dArray, n + 1, this.columnSpec.length - n);
        dArray[n] = d;
        this.columnSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.col1 >= n) {
                ++entry.col1;
            }
            if (entry.col2 < n) continue;
            ++entry.col2;
        }
        this.dirty = true;
    }

    public void insertRow(int n, double d) {
        if (n < 0 || n > this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + this.rowSpec.length + "].");
        }
        if (d < 0.0 && d != -1.0 && d != -2.0 && d != -3.0) {
            d = 0.0;
        }
        double[] dArray = new double[this.rowSpec.length + 1];
        System.arraycopy(this.rowSpec, 0, dArray, 0, n);
        System.arraycopy(this.rowSpec, n, dArray, n + 1, this.rowSpec.length - n);
        dArray[n] = d;
        this.rowSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.row1 >= n) {
                ++entry.row1;
            }
            if (entry.row2 < n) continue;
            ++entry.row2;
        }
        this.dirty = true;
    }

    public void deleteColumn(int n) {
        if (n < 0 || n >= this.columnSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + (this.columnSpec.length - 1) + "].");
        }
        double[] dArray = new double[this.columnSpec.length - 1];
        System.arraycopy(this.columnSpec, 0, dArray, 0, n);
        System.arraycopy(this.columnSpec, n + 1, dArray, n, this.columnSpec.length - n - 1);
        this.columnSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.col1 >= n) {
                --entry.col1;
            }
            if (entry.col2 < n) continue;
            --entry.col2;
        }
        this.dirty = true;
    }

    public void deleteRow(int n) {
        if (n < 0 || n >= this.rowSpec.length) {
            throw new IllegalArgumentException("Parameter i is invalid.  i = " + n + ".  Valid range is [0, " + (this.rowSpec.length - 1) + "].");
        }
        double[] dArray = new double[this.rowSpec.length - 1];
        System.arraycopy(this.rowSpec, 0, dArray, 0, n);
        System.arraycopy(this.rowSpec, n + 1, dArray, n, this.rowSpec.length - n - 1);
        this.rowSpec = dArray;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.row1 >= n) {
                --entry.row1;
            }
            if (entry.row2 < n) continue;
            --entry.row2;
        }
        this.dirty = true;
    }

    public String toString() {
        int n;
        String string = "TableLayout {{";
        if (this.columnSpec.length > 0) {
            for (n = 0; n < this.columnSpec.length - 1; ++n) {
                string = string + this.columnSpec[n] + ", ";
            }
            string = string + this.columnSpec[this.columnSpec.length - 1] + "}, {";
        } else {
            string = string + "}, {";
        }
        if (this.rowSpec.length > 0) {
            for (n = 0; n < this.rowSpec.length - 1; ++n) {
                string = string + this.rowSpec[n] + ", ";
            }
            string = string + this.rowSpec[this.rowSpec.length - 1] + "}}";
        } else {
            string = string + "}}";
        }
        return string;
    }

    public void drawGrid(Container container, Graphics graphics) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        int n = 0;
        for (int i = 0; i < this.rowSize.length; ++i) {
            int n2 = 0;
            for (int j = 0; j < this.columnSize.length; ++j) {
                Color color = new Color((int)(Math.random() * 1.6777215E7));
                graphics.setColor(color);
                graphics.fillRect(n2, n, this.columnSize[j], this.rowSize[i]);
                n2 += this.columnSize[j];
            }
            n += this.rowSize[i];
        }
    }

    public boolean hidden() {
        boolean bl = false;
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.row1 >= 0 && entry.col1 >= 0 && entry.row2 <= this.rowSpec.length && entry.col2 <= this.columnSpec.length) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean overlapping() {
        int n = this.list.size();
        if (n == 0) {
            return false;
        }
        boolean bl = false;
        Entry[] entryArray = this.list.toArray(new Entry[n]);
        block0: for (int i = 1; i < n; ++i) {
            for (int j = i - 1; j >= 0; --j) {
                if ((entryArray[j].col1 < entryArray[i].col1 || entryArray[j].col1 > entryArray[i].col2 || entryArray[j].row1 < entryArray[i].row1 || entryArray[j].row1 > entryArray[i].row2) && (entryArray[j].col2 < entryArray[i].col1 || entryArray[j].col2 > entryArray[i].col2 || entryArray[j].row2 < entryArray[i].row1 || entryArray[j].row2 > entryArray[i].row2)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    protected void calculateSize(Container container) {
        Dimension dimension;
        int n;
        Entry entry;
        ListIterator listIterator;
        int n2;
        int n3;
        int n4 = this.columnSpec.length;
        int n5 = this.rowSpec.length;
        this.columnSize = new int[n4];
        this.rowSize = new int[n5];
        Insets insets = container.getInsets();
        Dimension dimension2 = container.getSize();
        int n6 = dimension2.width - insets.left - insets.right;
        int n7 = dimension2.height - insets.top - insets.bottom;
        int n8 = n6;
        int n9 = n7;
        for (n3 = 0; n3 < n4; ++n3) {
            if (!(this.columnSpec[n3] >= 1.0) && this.columnSpec[n3] != 0.0) continue;
            this.columnSize[n3] = (int)(this.columnSpec[n3] + 0.5);
            n8 -= this.columnSize[n3];
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (!(this.rowSpec[n3] >= 1.0) && this.rowSpec[n3] != 0.0) continue;
            this.rowSize[n3] = (int)(this.rowSpec[n3] + 0.5);
            n9 -= this.rowSize[n3];
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.columnSpec[n3] != -2.0 && this.columnSpec[n3] != -3.0) continue;
            n2 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                entry = (Entry)listIterator.next();
                if (entry.col1 != n3 || entry.col2 != n3 || n2 >= (n = (dimension = this.columnSpec[n3] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.width)) continue;
                n2 = n;
            }
            this.columnSize[n3] = n2;
            n8 -= n2;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.rowSpec[n3] != -2.0 && this.rowSpec[n3] != -3.0) continue;
            n2 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                entry = (Entry)listIterator.next();
                if (entry.row1 != n3 || entry.row2 != n3 || n2 >= (n = (dimension = this.rowSpec[n3] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.height)) continue;
                n2 = n;
            }
            this.rowSize[n3] = n2;
            n9 -= n2;
        }
        n2 = n8;
        int n10 = n9;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n10 < 0) {
            n10 = 0;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (!(this.columnSpec[n3] > 0.0) || !(this.columnSpec[n3] < 1.0)) continue;
            this.columnSize[n3] = (int)(this.columnSpec[n3] * (double)n2 + 0.5);
            n8 -= this.columnSize[n3];
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (!(this.rowSpec[n3] > 0.0) || !(this.rowSpec[n3] < 1.0)) continue;
            this.rowSize[n3] = (int)(this.rowSpec[n3] * (double)n10 + 0.5);
            n9 -= this.rowSize[n3];
        }
        if (n8 < 0) {
            n8 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        int n11 = 0;
        int n12 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.columnSpec[n3] != -1.0) continue;
            ++n11;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.rowSpec[n3] != -1.0) continue;
            ++n12;
        }
        n = n8;
        int n13 = n9;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.columnSpec[n3] != -1.0) continue;
            this.columnSize[n3] = n8 / n11;
            n -= this.columnSize[n3];
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (this.rowSpec[n3] != -1.0) continue;
            this.rowSize[n3] = n9 / n12;
            n13 -= this.rowSize[n3];
        }
        for (n3 = n4 - 1; n3 >= 0; --n3) {
            if (this.columnSpec[n3] != -1.0) continue;
            int n14 = n3;
            this.columnSize[n14] = this.columnSize[n14] + n;
            break;
        }
        for (n3 = n5 - 1; n3 >= 0; --n3) {
            if (this.rowSpec[n3] != -1.0) continue;
            int n15 = n3;
            this.rowSize[n15] = this.rowSize[n15] + n13;
            break;
        }
        this.columnOffset = new int[n4 + 1];
        this.columnOffset[0] = insets.left;
        for (n3 = 0; n3 < n4; ++n3) {
            this.columnOffset[n3 + 1] = this.columnOffset[n3] + this.columnSize[n3];
        }
        this.rowOffset = new int[n5 + 1];
        this.rowOffset[0] = insets.top;
        for (n3 = 0; n3 < n5; ++n3) {
            this.rowOffset[n3 + 1] = this.rowOffset[n3] + this.rowSize[n3];
        }
        this.dirty = false;
        this.oldWidth = n6;
        this.oldHeight = n7;
    }

    @Override
    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        if (this.dirty || dimension.width != this.oldWidth || dimension.height != this.oldHeight) {
            this.calculateSize(container);
        }
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            try {
                int n;
                int n2;
                int n3;
                int n4;
                ListIterator listIterator = this.list.listIterator(0);
                Entry entry = null;
                while (listIterator.hasNext()) {
                    entry = (Entry)listIterator.next();
                    if (entry.component == componentArray[i]) break;
                    entry = null;
                }
                if (entry == null) break;
                if (entry.singleCell) {
                    int n5 = 0;
                    int n6 = 0;
                    if (entry.hAlign != 2 || entry.vAlign != 2) {
                        Dimension dimension2 = componentArray[i].getPreferredSize();
                        n5 = dimension2.width;
                        n6 = dimension2.height;
                    }
                    int n7 = this.columnSize[entry.col1];
                    int n8 = this.rowSize[entry.row1];
                    n4 = entry.hAlign == 2 || n7 < n5 ? n7 : n5;
                    switch (entry.hAlign) {
                        case 0: {
                            n3 = this.columnOffset[entry.col1];
                            break;
                        }
                        case 3: {
                            n3 = this.columnOffset[entry.col1 + 1] - n4;
                            break;
                        }
                        case 1: {
                            n3 = this.columnOffset[entry.col1] + (n7 - n4 >> 1);
                            break;
                        }
                        case 2: {
                            n3 = this.columnOffset[entry.col1];
                            break;
                        }
                        default: {
                            n3 = 0;
                        }
                    }
                    n2 = entry.vAlign == 2 || n8 < n6 ? n8 : n6;
                    switch (entry.vAlign) {
                        case 0: {
                            n = this.rowOffset[entry.row1];
                            break;
                        }
                        case 3: {
                            n = this.rowOffset[entry.row1 + 1] - n2;
                            break;
                        }
                        case 1: {
                            n = this.rowOffset[entry.row1] + (n8 - n2 >> 1);
                            break;
                        }
                        case 2: {
                            n = this.rowOffset[entry.row1];
                            break;
                        }
                        default: {
                            n = 0;
                            break;
                        }
                    }
                } else {
                    n3 = this.columnOffset[entry.col1];
                    n = this.rowOffset[entry.row1];
                    n4 = this.columnOffset[entry.col2 + 1] - this.columnOffset[entry.col1];
                    n2 = this.rowOffset[entry.row2 + 1] - this.rowOffset[entry.row1];
                }
                componentArray[i].setBounds(n3, n, n4, n2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        int n3 = 0;
        double d = 1.0;
        double d2 = 1.0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.columnSpec.length; ++n) {
            if (this.columnSpec[n] > 0.0 && this.columnSpec[n] < 1.0) {
                d -= this.columnSpec[n];
                continue;
            }
            if (this.columnSpec[n] != -1.0) continue;
            ++n4;
        }
        for (n = 0; n < this.rowSpec.length; ++n) {
            if (this.rowSpec[n] > 0.0 && this.rowSpec[n] < 1.0) {
                d2 -= this.rowSpec[n];
                continue;
            }
            if (this.rowSpec[n] != -1.0) continue;
            ++n5;
        }
        if (n4 > 1) {
            d /= (double)n4;
        }
        if (n5 > 1) {
            d2 /= (double)n5;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        int[] nArray = new int[this.columnSpec.length];
        for (n = 0; n < this.columnSpec.length; ++n) {
            if (this.columnSpec[n] != -2.0 && this.columnSpec[n] != -3.0) continue;
            int n6 = 0;
            ListIterator listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                int n7;
                object2 = (Entry)listIterator.next();
                if (((Entry)object2).col1 != n || ((Entry)object2).col2 != n || n6 >= (n7 = (object = this.columnSpec[n] == -2.0 ? ((Entry)object2).component.getPreferredSize() : ((Entry)object2).component.getMinimumSize()) == null ? 0 : ((Dimension)object).width)) continue;
                n6 = n7;
            }
            nArray[n] = n6;
        }
        int[] nArray2 = new int[this.rowSpec.length];
        for (n = 0; n < this.rowSpec.length; ++n) {
            if (this.rowSpec[n] != -2.0 && this.rowSpec[n] != -3.0) continue;
            int n8 = 0;
            object2 = this.list.listIterator(0);
            while (object2.hasNext()) {
                Dimension dimension;
                int n9;
                object = (Entry)object2.next();
                if (((Entry)object).row1 != n || n8 >= (n9 = (dimension = this.rowSpec[n] == -2.0 ? ((Entry)object).component.getPreferredSize() : ((Entry)object).component.getMinimumSize()) == null ? 0 : dimension.height)) continue;
                n8 = n9;
            }
            int n10 = n;
            nArray2[n10] = nArray2[n10] + n8;
        }
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            object2 = (Entry)listIterator.next();
            if (((Entry)object2).col1 < 0 || ((Entry)object2).col1 >= this.columnSpec.length || ((Entry)object2).col2 >= this.columnSpec.length || ((Entry)object2).row1 < 0 || ((Entry)object2).row1 >= this.rowSpec.length || ((Entry)object2).row2 >= this.rowSpec.length) continue;
            Dimension dimension = ((Entry)object2).component.getPreferredSize();
            int n11 = dimension.width;
            int n12 = dimension.height;
            for (n = ((Entry)object2).col1; n <= ((Entry)object2).col2; ++n) {
                if (this.columnSpec[n] >= 1.0) {
                    n11 = (int)((double)n11 - this.columnSpec[n]);
                    continue;
                }
                if (this.columnSpec[n] != -2.0 && this.columnSpec[n] != -3.0) continue;
                n11 -= nArray[n];
            }
            for (n = ((Entry)object2).row1; n <= ((Entry)object2).row2; ++n) {
                if (this.rowSpec[n] >= 1.0) {
                    n12 = (int)((double)n12 - this.rowSpec[n]);
                    continue;
                }
                if (this.rowSpec[n] != -2.0 && this.rowSpec[n] != -3.0) continue;
                n12 -= nArray2[n];
            }
            double d3 = 0.0;
            for (n = ((Entry)object2).col1; n <= ((Entry)object2).col2; ++n) {
                if (this.columnSpec[n] > 0.0 && this.columnSpec[n] < 1.0) {
                    d3 += this.columnSpec[n];
                    continue;
                }
                if (this.columnSpec[n] != -1.0 || d == 0.0) continue;
                d3 += d;
            }
            int n13 = d3 == 0.0 ? 0 : (int)((double)n11 / d3 + 0.5);
            if (n2 < n13) {
                n2 = n13;
            }
            double d4 = 0.0;
            for (n = ((Entry)object2).row1; n <= ((Entry)object2).row2; ++n) {
                if (this.rowSpec[n] > 0.0 && this.rowSpec[n] < 1.0) {
                    d4 += this.rowSpec[n];
                    continue;
                }
                if (this.rowSpec[n] != -1.0 || d2 == 0.0) continue;
                d4 += d2;
            }
            n13 = d4 == 0.0 ? 0 : (int)((double)n12 / d4 + 0.5);
            if (n3 >= n13) continue;
            n3 = n13;
        }
        int n14 = n2;
        for (n = 0; n < this.columnSpec.length; ++n) {
            if (this.columnSpec[n] >= 1.0) {
                n14 += (int)(this.columnSpec[n] + 0.5);
                continue;
            }
            if (this.columnSpec[n] != -2.0 && this.columnSpec[n] != -3.0) continue;
            n14 += nArray[n];
        }
        int n15 = n3;
        for (n = 0; n < this.rowSpec.length; ++n) {
            if (this.rowSpec[n] >= 1.0) {
                n15 += (int)(this.rowSpec[n] + 0.5);
                continue;
            }
            if (this.rowSpec[n] != -2.0 && this.rowSpec[n] != -3.0) continue;
            n15 += nArray2[n];
        }
        Insets insets = container.getInsets();
        return new Dimension(n14 += insets.left + insets.right, n15 += insets.top + insets.bottom);
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        double d = 1.0;
        double d2 = 1.0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < this.columnSpec.length; ++n2) {
            if (this.columnSpec[n2] > 0.0 && this.columnSpec[n2] < 1.0) {
                d -= this.columnSpec[n2];
                continue;
            }
            if (this.columnSpec[n2] != -1.0) continue;
            ++n5;
        }
        for (n2 = 0; n2 < this.rowSpec.length; ++n2) {
            if (this.rowSpec[n2] > 0.0 && this.rowSpec[n2] < 1.0) {
                d2 -= this.rowSpec[n2];
                continue;
            }
            if (this.rowSpec[n2] != -1.0) continue;
            ++n6;
        }
        if (n5 > 1) {
            d /= (double)n5;
        }
        if (n6 > 1) {
            d2 /= (double)n6;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d2 < 0.0) {
            d2 = 0.0;
        }
        ListIterator listIterator = this.list.listIterator(0);
        while (listIterator.hasNext()) {
            Entry entry = (Entry)listIterator.next();
            if (entry.col1 < 0 || entry.col1 >= this.columnSpec.length || entry.col2 >= this.columnSpec.length || entry.row1 < 0 || entry.row1 >= this.rowSpec.length || entry.row2 >= this.rowSpec.length) continue;
            Dimension dimension = entry.component.getMinimumSize();
            n = dimension.width;
            int n7 = dimension.height;
            for (n2 = entry.col1; n2 <= entry.col2; ++n2) {
                if (!(this.columnSpec[n2] >= 1.0)) continue;
                n = (int)((double)n - this.columnSpec[n2]);
            }
            for (n2 = entry.row1; n2 <= entry.row2; ++n2) {
                if (!(this.rowSpec[n2] >= 1.0)) continue;
                n7 = (int)((double)n7 - this.rowSpec[n2]);
            }
            double d3 = 0.0;
            for (n2 = entry.col1; n2 <= entry.col2; ++n2) {
                if (this.columnSpec[n2] > 0.0 && this.columnSpec[n2] < 1.0) {
                    d3 += this.columnSpec[n2];
                    continue;
                }
                if (this.columnSpec[n2] != -1.0 || d == 0.0) continue;
                d3 += d;
            }
            int n8 = d3 == 0.0 ? 0 : (int)((double)n / d3 + 0.5);
            if (n3 < n8) {
                n3 = n8;
            }
            double d4 = 0.0;
            for (n2 = entry.row1; n2 <= entry.row2; ++n2) {
                if (this.rowSpec[n2] > 0.0 && this.rowSpec[n2] < 1.0) {
                    d4 += this.rowSpec[n2];
                    continue;
                }
                if (this.rowSpec[n2] != -1.0 || d2 == 0.0) continue;
                d4 += d2;
            }
            n8 = d4 == 0.0 ? 0 : (int)((double)n7 / d4 + 0.5);
            if (n4 >= n8) continue;
            n4 = n8;
        }
        int n9 = n3;
        for (n2 = 0; n2 < this.columnSpec.length; ++n2) {
            if (this.columnSpec[n2] >= 1.0) {
                n9 += (int)(this.columnSpec[n2] + 0.5);
                continue;
            }
            if (this.columnSpec[n2] != -2.0 && this.columnSpec[n2] != -3.0) continue;
            n = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Dimension dimension;
                int n10;
                Entry entry = (Entry)listIterator.next();
                if (entry.col1 != n2 || entry.col2 != n2 || n >= (n10 = (dimension = this.columnSpec[n2] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.width)) continue;
                n = n10;
            }
            n9 += n;
        }
        n = n4;
        for (n2 = 0; n2 < this.rowSpec.length; ++n2) {
            if (this.rowSpec[n2] >= 1.0) {
                n += (int)(this.rowSpec[n2] + 0.5);
                continue;
            }
            if (this.rowSpec[n2] != -2.0 && this.rowSpec[n2] != -3.0) continue;
            int n11 = 0;
            listIterator = this.list.listIterator(0);
            while (listIterator.hasNext()) {
                Dimension dimension;
                int n12;
                Entry entry = (Entry)listIterator.next();
                if (entry.row1 != n2 || n11 >= (n12 = (dimension = this.rowSpec[n2] == -2.0 ? entry.component.getPreferredSize() : entry.component.getMinimumSize()) == null ? 0 : dimension.height)) continue;
                n11 = n12;
            }
            n += n11;
        }
        Insets insets = container.getInsets();
        return new Dimension(n9 += insets.left + insets.right, n += insets.top + insets.bottom);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object instanceof String) {
            object = new TableLayoutConstraints((String)object);
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
        } else if (object instanceof TableLayoutConstraints) {
            this.list.add(new Entry(component, (TableLayoutConstraints)object));
        } else {
            if (object == null) {
                throw new IllegalArgumentException("No constraint for the component");
            }
            throw new IllegalArgumentException("Cannot accept a constraint of class " + object.getClass());
        }
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.list.remove(component);
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
        this.dirty = true;
    }

    protected class Entry
    extends TableLayoutConstraints {
        protected Component component;
        protected boolean singleCell;

        public Entry(Component component, TableLayoutConstraints tableLayoutConstraints) {
            super(tableLayoutConstraints.col1, tableLayoutConstraints.row1, tableLayoutConstraints.col2, tableLayoutConstraints.row2, tableLayoutConstraints.hAlign, tableLayoutConstraints.vAlign);
            this.singleCell = this.row1 == this.row2 && this.col1 == this.col2;
            this.component = component;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Component) {
                Component component = (Component)object;
                bl = this.component == component;
            }
            return bl;
        }
    }
}

