/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;

abstract class AbstractHandler
extends Handler {
    public AbstractHandler() {
        this.configure();
    }

    protected Level getLevelProperty(String string, Level level) {
        String string2 = LogManager.getLogManager().getProperty(string);
        if (string2 == null) {
            return level;
        }
        try {
            return Level.parse(string2.trim());
        }
        catch (Exception exception) {
            return level;
        }
    }

    protected Filter getFilterProperty(String string, Filter filter) {
        String string2 = LogManager.getLogManager().getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Filter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filter;
    }

    protected Formatter getFormatterProperty(String string, Formatter formatter) {
        String string2 = LogManager.getLogManager().getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatter;
    }

    protected String getStringProperty(String string, String string2) {
        String string3 = LogManager.getLogManager().getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    protected void configure() {
        String string = this.getClass().getName();
        this.setLevel(this.getLevelProperty(string + ".level", Level.ALL));
        this.setFilter(this.getFilterProperty(string + ".filter", null));
        this.setFormatter(this.getFormatterProperty(string + ".formatter", new SimpleFormatter()));
        try {
            this.setEncoding(this.getStringProperty(string + ".encoding", null));
        }
        catch (Exception exception) {
            try {
                this.setEncoding(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

