/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import com.adesoft.log.LogBuffer;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Category {
    private static final Map categories = new TreeMap();
    private final Logger logger;

    private Category(String string) {
        this.logger = Logger.getLogger(string);
    }

    public static final synchronized Category getInstance(String string) {
        Object v = categories.get(string);
        if (null != v) {
            return (Category)v;
        }
        Category category = new Category(string);
        categories.put(string, category);
        return category;
    }

    public final void debug(Object object) {
        LogBuffer logBuffer = new LogBuffer();
        logBuffer.appendCurrentDate();
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            logBuffer.append(" " + this.logger.getName() + "-" + String.valueOf(object));
            this.logger.log(Level.FINE, logBuffer.toString());
            this.logger.log(Level.FINE, byteArrayOutputStream.toString());
        } else {
            logBuffer.append(" " + String.valueOf(object));
            this.logger.log(Level.FINE, logBuffer.toString());
        }
    }

    public final void error(Object object) {
        LogBuffer logBuffer = new LogBuffer();
        logBuffer.appendCurrentDate();
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            logBuffer.append(" " + this.logger.getName() + "-" + String.valueOf(object));
            this.logger.log(Level.WARNING, logBuffer.toString());
            this.logger.log(Level.WARNING, byteArrayOutputStream.toString());
        } else {
            logBuffer.append(" " + String.valueOf(object));
            this.logger.log(Level.WARNING, logBuffer.toString());
        }
    }

    public final void info(Object object) {
        LogBuffer logBuffer = new LogBuffer();
        logBuffer.appendCurrentDate();
        if (object instanceof Throwable) {
            logBuffer.append(" " + this.logger.getName() + "-" + String.valueOf(object));
            this.logger.log(Level.INFO, logBuffer.toString());
        } else {
            logBuffer.append(" " + String.valueOf(object));
            this.logger.log(Level.INFO, logBuffer.toString());
        }
    }

    public final void security(Object object) {
        LogBuffer logBuffer = new LogBuffer();
        logBuffer.appendCurrentDate();
        if (object instanceof Throwable) {
            logBuffer.append(" " + this.logger.getName() + "-" + String.valueOf(object));
            this.logger.log(Level.SEVERE, logBuffer.toString());
        } else {
            logBuffer.append(" " + String.valueOf(object));
            this.logger.log(Level.SEVERE, logBuffer.toString());
        }
    }
}

