/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import com.adesoft.log.LogMode;
import com.adesoft.log.SimpleFileHandler;
import com.adesoft.log.StdLogFormatter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class DefaultLogConfiguration {
    public static DefaultLogConfiguration instance;

    private DefaultLogConfiguration() {
    }

    public static synchronized DefaultLogConfiguration getInstance() {
        if (null == instance) {
            instance = new DefaultLogConfiguration();
        }
        return instance;
    }

    public void initServerSide(String string, String string2) throws IOException {
        Logger logger = Logger.getLogger("");
        Level level = Level.parse(LogMode.convert(string));
        logger.setLevel(level);
        if (null == string2) {
            logger.addHandler(new ConsoleHandler());
        } else {
            logger.addHandler(new SimpleFileHandler(string2));
        }
    }

    private static void parseCommandLine(String[] stringArray, Map map) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(61);
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            map.put(string2, string3);
        }
    }

    public void init(String[] stringArray, String string) throws IOException {
        TreeMap treeMap = new TreeMap();
        DefaultLogConfiguration.parseCommandLine(stringArray, treeMap);
        String string2 = treeMap.containsKey("LogMode") ? (String)treeMap.get("LogMode") : LogMode.EXCEPTION.getName();
        String string3 = !treeMap.containsKey("LogFile") || "true".equals(treeMap.get("LogFile")) ? string : null;
        this.init(Level.parse(LogMode.convert(string2)), string3);
    }

    public void init(Level level, String string) throws IOException {
        LogManager.getLogManager().reset();
        Logger logger = Logger.getLogger("");
        logger.setLevel(level);
        Logger.getLogger("sun").setLevel(Level.INFO);
        Logger.getLogger("java").setLevel(Level.INFO);
        Logger.getLogger("javax").setLevel(Level.INFO);
        if (null == string) {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new StdLogFormatter());
            consoleHandler.setLevel(Level.ALL);
            logger.addHandler(consoleHandler);
        } else {
            SimpleFileHandler simpleFileHandler = new SimpleFileHandler(string);
            simpleFileHandler.setFormatter(new StdLogFormatter());
            simpleFileHandler.setLevel(Level.ALL);
            logger.addHandler(simpleFileHandler);
        }
    }
}

