/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import java.io.Serializable;
import java.util.logging.Level;

public final class LogMode
implements Serializable {
    private static final long serialVersionUID = 520L;
    static final LogMode INTERNAL = new LogMode("INTERNAL", -1);
    public static final LogMode SECURITY = new LogMode("SECURITY", 0);
    public static final LogMode EXCEPTION = new LogMode("EXCEPTION", 2);
    public static final LogMode INFO = new LogMode("INFO", 3);
    public static final LogMode DEBUG = new LogMode("DEBUG", 4);
    private static int nextOrdinal = 0;
    private static final LogMode[] VALS = new LogMode[]{INTERNAL, SECURITY, EXCEPTION, INFO, DEBUG};
    private final int ordinal = nextOrdinal++;
    private final transient String name;
    private final transient int priority;

    private LogMode(String string, int n) {
        this.name = string;
        this.priority = n;
    }

    public static LogMode getByName(String string) {
        if (null == string) {
            return INFO;
        }
        for (int i = VALS.length - 1; i >= 0; --i) {
            if (!VALS[i].getName().equalsIgnoreCase(string)) continue;
            return VALS[i];
        }
        return INFO;
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isDisplayed(LogMode logMode) {
        return this.getPriority() <= logMode.getPriority();
    }

    public Object readResolve() {
        return VALS[this.ordinal];
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LogMode) {
            return this.ordinal == ((LogMode)object).ordinal;
        }
        return false;
    }

    public static final Level getLevel(LogMode logMode) {
        if (SECURITY.equals(logMode)) {
            return Level.SEVERE;
        }
        if (EXCEPTION.equals(logMode)) {
            return Level.WARNING;
        }
        if (INFO.equals(logMode)) {
            return Level.INFO;
        }
        if (DEBUG.equals(logMode)) {
            return Level.FINE;
        }
        return Level.OFF;
    }

    public static final String convert(String string) {
        if ("SECURITY".equalsIgnoreCase(string)) {
            return Level.SEVERE.getName();
        }
        if ("EXCEPTION".equalsIgnoreCase(string)) {
            return Level.WARNING.getName();
        }
        if ("INFO".equalsIgnoreCase(string)) {
            return Level.INFO.getName();
        }
        if ("DEBUG".equalsIgnoreCase(string)) {
            return Level.FINE.getName();
        }
        if ("NONE".equalsIgnoreCase(string)) {
            return Level.OFF.getName();
        }
        return string.toUpperCase();
    }
}

