/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import com.adesoft.log.AbstractHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.LogRecord;

public final class SimpleFileHandler
extends AbstractHandler {
    private final PrintWriter writer;

    public SimpleFileHandler(String string) throws IOException {
        this.configure();
        this.writer = this.openFile(string);
    }

    private PrintWriter openFile(String string) throws IOException {
        return new PrintWriter(new FileWriter(string));
    }

    @Override
    public synchronized void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        try {
            this.writer.close();
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            this.writer.write(string);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
        this.flush();
    }
}

