/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.log;

import com.adesoft.log.AbstractHandler;
import com.adesoft.log.RemoteLogger;
import com.adesoft.log.SpyManager;
import java.util.logging.LogRecord;

public final class SpyHandler
extends AbstractHandler {
    public SpyHandler() {
        this.configure();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        SpyManager.getInstance().unregister();
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        RemoteLogger remoteLogger = SpyManager.getInstance().getSpy();
        if (null != remoteLogger) {
            String string;
            try {
                string = this.getFormatter().format(logRecord);
            }
            catch (Exception exception) {
                this.reportError(null, exception, 5);
                return;
            }
            try {
                remoteLogger.log(string);
            }
            catch (Exception exception) {
                this.reportError(null, exception, 1);
            }
        }
    }
}

