/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.misc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static String STR_DEFAULT_FILE_NAME = "ADE_MailService_Default.log";
    private static Logger _instance = null;
    private PrintWriter _fileLog = null;
    private String _strFileName;

    private Logger(String string) throws IOException {
        this.openLogFile(string);
    }

    private PrintWriter getLogWriter() {
        return this._fileLog;
    }

    private void setLogWriter(PrintWriter printWriter) {
        this._fileLog = printWriter;
    }

    private synchronized void openLogFile(String string) throws IOException {
        this.setLogWriter(new PrintWriter(new FileWriter(string)));
    }

    private static synchronized Logger getInstance() throws IOException {
        if (null == _instance) {
            _instance = new Logger(STR_DEFAULT_FILE_NAME);
        }
        return _instance;
    }

    public static void instantiate(String string) throws IOException {
        _instance = new Logger(string);
    }

    public static synchronized void info(String string) {
        try {
            Logger.getInstance().appendLine("< info > " + Logger.getDateTimeString() + " " + string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    public static synchronized void error(String string) {
        try {
            Logger.getInstance().appendLine("< ERROR > " + Logger.getDateTimeString() + " " + string);
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
    }

    private synchronized void appendLine(String string) {
        if (null != this.getLogWriter()) {
            this.getLogWriter().println(string);
            this.getLogWriter().flush();
        }
    }

    private static String getDateTimeString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("[yyyy-MMM-dd kk:mm:ss]");
        String string = simpleDateFormat.format(new Date());
        return string;
    }

    protected void finalize() throws Throwable {
        if (null == this.getLogWriter()) {
            return;
        }
        this.getLogWriter().flush();
        this.getLogWriter().close();
        super.finalize();
    }

    public void setFileName(String string) {
        this._strFileName = string;
    }

    public String getFileName() {
        return this._strFileName;
    }
}

