/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.proxies;

import com.adesoft.proxies.RetryProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.rmi.RemoteException;

public class RetryProxy
implements InvocationHandler {
    private static final int MAX_TRY = 3;
    protected final RetryProvider provider;
    protected Object object;

    private RetryProxy(RetryProvider retryProvider) {
        this.provider = retryProvider;
    }

    public static Object newInstance(RetryProvider retryProvider, Class clazz) {
        if (null == retryProvider) {
            throw new IllegalArgumentException("Impossible to create Proxy");
        }
        Class[] classArray = new Class[]{clazz};
        return Proxy.newProxyInstance(retryProvider.getClass().getClassLoader(), classArray, (InvocationHandler)new RetryProxy(retryProvider));
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Throwable throwable = null;
        for (int i = 0; i < 3; ++i) {
            try {
                if (null == this.object) {
                    this.object = this.provider.createProxyObject();
                }
                return method.invoke(this.object, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable2 = invocationTargetException.getTargetException();
                if (!(throwable2 instanceof ConnectException) && !(throwable2 instanceof RemoteException)) {
                    throw throwable2;
                }
                this.object = null;
                throwable = throwable2;
                continue;
            }
        }
        throw throwable;
    }
}

