/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.rmi;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class DefaultSocketBehavior {
    private static boolean paramsLoaded = false;
    public static Boolean CLIENT_KEEPALIVE;
    public static Boolean SERVER_KEEPALIVE;
    public static Boolean CLIENT_OOBINLINE;
    public static Boolean SERVER_OOBINLINE;
    public static Integer CLIENT_PERFTIME;
    public static Integer CLIENT_PERFLATENCY;
    public static Integer CLIENT_PERFBANDWITH;
    public static Integer SERVER_PERFTIME;
    public static Integer SERVER_PERFLATENCY;
    public static Integer SERVER_PERFBANDWITH;
    public static Integer CLIENT_SNDBUF;
    public static Integer SERVER_SNDBUF;
    public static Integer CLIENT_RCVBUF;
    public static Integer SERVER_RCVBUF;
    public static Boolean CLIENT_REUSEADDR;
    public static Boolean SERVER_REUSEADDR;
    public static Integer CLIENT_LINGER;
    public static Integer SERVER_LINGER;
    public static Integer CLIENT_TIMEOUT;
    public static Integer SERVER_TIMEOUT;
    public static Boolean CLIENT_NODELAY;
    public static Boolean SERVER_NODELAY;

    private static void loadParams() {
        if (!paramsLoaded) {
            Integer n = Integer.getInteger("com.adesoft.server.tcp_keepalive");
            if (null != n) {
                SERVER_KEEPALIVE = DefaultSocketBehavior.getBoolValue(n);
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_oobinline"))) {
                SERVER_OOBINLINE = DefaultSocketBehavior.getBoolValue(n);
            }
            Integer n2 = Integer.getInteger("com.adesoft.server.tcp_perftime");
            Integer n3 = Integer.getInteger("com.adesoft.server.tcp_perflatency");
            Integer n4 = Integer.getInteger("com.adesoft.server.tcp_perfbandwith");
            if (null != n2 && null != n3 && null != n4) {
                SERVER_PERFTIME = n2;
                SERVER_PERFLATENCY = n3;
                SERVER_PERFBANDWITH = n4;
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_rcvbuf"))) {
                SERVER_RCVBUF = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_reuseaddr"))) {
                SERVER_REUSEADDR = DefaultSocketBehavior.getBoolValue(n);
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_sndbuf"))) {
                SERVER_SNDBUF = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_linger"))) {
                SERVER_LINGER = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_timeout"))) {
                SERVER_TIMEOUT = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.server.tcp_nodelay"))) {
                SERVER_NODELAY = DefaultSocketBehavior.getBoolValue(n);
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_keepalive"))) {
                CLIENT_KEEPALIVE = DefaultSocketBehavior.getBoolValue(n);
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_oobinline"))) {
                CLIENT_OOBINLINE = DefaultSocketBehavior.getBoolValue(n);
            }
            n2 = Integer.getInteger("com.adesoft.client.tcp_perftime");
            n3 = Integer.getInteger("com.adesoft.client.tcp_perflatency");
            n4 = Integer.getInteger("com.adesoft.client.tcp_perfbandwith");
            if (null != n2 && null != n3 && null != n4) {
                CLIENT_PERFTIME = n2;
                CLIENT_PERFLATENCY = n3;
                CLIENT_PERFBANDWITH = n4;
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_rcvbuf"))) {
                CLIENT_RCVBUF = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_reuseaddr"))) {
                CLIENT_REUSEADDR = DefaultSocketBehavior.getBoolValue(n);
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_sndbuf"))) {
                CLIENT_SNDBUF = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_linger"))) {
                CLIENT_LINGER = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_timeout"))) {
                CLIENT_TIMEOUT = n;
            }
            if (null != (n = Integer.getInteger("com.adesoft.client.tcp_nodelay"))) {
                CLIENT_NODELAY = DefaultSocketBehavior.getBoolValue(n);
            }
            paramsLoaded = true;
        }
    }

    public static void applyServerBehavior(Socket socket) {
        try {
            DefaultSocketBehavior.loadParams();
            if (null != SERVER_KEEPALIVE) {
                socket.setKeepAlive(SERVER_KEEPALIVE);
            }
            if (null != SERVER_OOBINLINE) {
                socket.setOOBInline(SERVER_OOBINLINE);
            }
            if (null != SERVER_PERFTIME && null != SERVER_PERFLATENCY && null != SERVER_PERFBANDWITH) {
                socket.setPerformancePreferences(SERVER_PERFTIME, SERVER_PERFLATENCY, SERVER_PERFBANDWITH);
            }
            if (null != SERVER_RCVBUF) {
                socket.setReceiveBufferSize(SERVER_RCVBUF);
            }
            if (null != SERVER_REUSEADDR) {
                socket.setReuseAddress(SERVER_REUSEADDR);
            }
            if (null != SERVER_SNDBUF) {
                socket.setSendBufferSize(SERVER_SNDBUF);
            }
            if (null != SERVER_LINGER) {
                socket.setSoLinger(true, SERVER_LINGER);
            }
            if (null != SERVER_TIMEOUT) {
                socket.setSoTimeout(SERVER_TIMEOUT);
            }
            if (null != SERVER_NODELAY) {
                socket.setTcpNoDelay(SERVER_NODELAY);
            }
        }
        catch (SocketException socketException) {
            System.out.println(socketException);
        }
    }

    public static void applyServerBehavior(ServerSocket serverSocket) {
        try {
            DefaultSocketBehavior.loadParams();
            if (null != SERVER_PERFTIME && null != SERVER_PERFLATENCY && null != SERVER_PERFBANDWITH) {
                serverSocket.setPerformancePreferences(SERVER_PERFTIME, SERVER_PERFLATENCY, SERVER_PERFBANDWITH);
            }
            if (null != SERVER_RCVBUF) {
                serverSocket.setReceiveBufferSize(SERVER_RCVBUF);
            }
            if (null != SERVER_REUSEADDR) {
                serverSocket.setReuseAddress(SERVER_REUSEADDR);
            }
            if (null != SERVER_TIMEOUT) {
                serverSocket.setSoTimeout(SERVER_TIMEOUT);
            }
        }
        catch (SocketException socketException) {
            System.out.println(socketException);
        }
    }

    public static void applyClientBehavior(Socket socket) {
        try {
            DefaultSocketBehavior.loadParams();
            if (null != CLIENT_KEEPALIVE) {
                socket.setKeepAlive(CLIENT_KEEPALIVE);
            }
            if (null != CLIENT_OOBINLINE) {
                socket.setOOBInline(CLIENT_OOBINLINE);
            }
            if (null != CLIENT_PERFTIME && null != CLIENT_PERFLATENCY && null != CLIENT_PERFBANDWITH) {
                socket.setPerformancePreferences(CLIENT_PERFTIME, CLIENT_PERFLATENCY, CLIENT_PERFBANDWITH);
            }
            if (null != CLIENT_RCVBUF) {
                socket.setReceiveBufferSize(CLIENT_RCVBUF);
            }
            if (null != CLIENT_REUSEADDR) {
                socket.setReuseAddress(CLIENT_REUSEADDR);
            }
            if (null != CLIENT_SNDBUF) {
                socket.setSendBufferSize(CLIENT_SNDBUF);
            }
            if (null != CLIENT_LINGER) {
                socket.setSoLinger(true, CLIENT_LINGER);
            }
            if (null != CLIENT_TIMEOUT) {
                socket.setSoTimeout(CLIENT_TIMEOUT);
            }
            if (null != CLIENT_NODELAY) {
                socket.setTcpNoDelay(CLIENT_NODELAY);
            }
        }
        catch (SocketException socketException) {
            System.out.println(socketException);
        }
    }

    public static void applyClientBehavior(ServerSocket serverSocket) {
        try {
            DefaultSocketBehavior.loadParams();
            if (null != CLIENT_PERFTIME && null != CLIENT_PERFLATENCY && null != CLIENT_PERFBANDWITH) {
                serverSocket.setPerformancePreferences(CLIENT_PERFTIME, CLIENT_PERFLATENCY, CLIENT_PERFBANDWITH);
            }
            if (null != CLIENT_RCVBUF) {
                serverSocket.setReceiveBufferSize(CLIENT_RCVBUF);
            }
            if (null != CLIENT_REUSEADDR) {
                serverSocket.setReuseAddress(CLIENT_REUSEADDR);
            }
            if (null != CLIENT_TIMEOUT) {
                serverSocket.setSoTimeout(CLIENT_TIMEOUT);
            }
        }
        catch (SocketException socketException) {
            System.out.println(socketException);
        }
    }

    public static String getAllParams(Socket socket) {
        String string = "";
        try {
            string = string + "KeepALive=" + socket.getKeepAlive();
            string = string + " OOBinline=" + socket.getOOBInline();
            string = string + " RcvBuf=" + socket.getReceiveBufferSize();
            string = string + " ReuseAddr=" + socket.getReuseAddress();
            string = string + " SndBuf=" + socket.getSendBufferSize();
            string = string + " SoLinger=" + socket.getSoLinger();
            string = string + " SoTimeout=" + socket.getSoTimeout();
            string = string + " NoDelay=" + socket.getTcpNoDelay();
        }
        catch (SocketException socketException) {
            System.out.println(socketException);
        }
        return string;
    }

    public static String getAllParams(ServerSocket serverSocket) {
        String string = "";
        try {
            string = string + "RcvBuf=" + serverSocket.getReceiveBufferSize();
            string = string + " ReuseAddr=" + serverSocket.getReuseAddress();
            string = string + " SoTimeout=" + serverSocket.getSoTimeout();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return string;
    }

    private static boolean getBoolValue(int n) {
        return 0 != n;
    }
}

