/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.rmi;

import com.adesoft.log.Category;
import com.adesoft.rmi.GlobalRMIFlags;
import com.adesoft.rmi.Proxy;
import java.lang.ref.WeakReference;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MyRMI {
    private static final Category LOG = Category.getInstance("com.adesoft.rmi.MyRMI");
    private static final HashMap<Remote, WeakReference<Object>> rmiObjects = new HashMap(1000, 0.75f);

    private MyRMI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int clear() {
        if (GlobalRMIFlags.getInstance().isLocalMode()) {
            return 0;
        }
        int n = 0;
        HashMap<Remote, WeakReference<Object>> hashMap = rmiObjects;
        synchronized (hashMap) {
            Iterator<Map.Entry<Remote, WeakReference<Object>>> iterator = rmiObjects.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Remote, WeakReference<Object>> entry = iterator.next();
                WeakReference<Object> weakReference = entry.getValue();
                if (null != weakReference && null != weakReference.get()) continue;
                ++n;
                iterator.remove();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportObject(Remote remote) throws RemoteException {
        if (GlobalRMIFlags.getInstance().isLocalMode()) {
            return;
        }
        Remote remote2 = UnicastRemoteObject.exportObject(remote, GlobalRMIFlags.getInstance().getRmiPort());
        HashMap<Remote, WeakReference<Object>> hashMap = rmiObjects;
        synchronized (hashMap) {
            rmiObjects.put(remote2, new WeakReference<Remote>((Remote)(remote instanceof Proxy ? ((Proxy)((Object)remote)).getRef() : remote)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getImpl(Remote remote) {
        WeakReference<Object> weakReference;
        HashMap<Remote, WeakReference<Object>> hashMap = rmiObjects;
        synchronized (hashMap) {
            weakReference = rmiObjects.get(remote);
        }
        if (null != weakReference) {
            hashMap = weakReference.get();
            if (null != hashMap) {
                return hashMap;
            }
            HashMap<Remote, WeakReference<Object>> hashMap2 = rmiObjects;
            synchronized (hashMap2) {
                rmiObjects.remove(remote);
            }
            return hashMap;
        }
        return remote;
    }

    public static Object getLocal(Object object) {
        if (GlobalRMIFlags.getInstance().isLocalMode()) {
            if (object instanceof Proxy) {
                return ((Proxy)object).getRef();
            }
            return object;
        }
        if (object instanceof Remote) {
            return MyRMI.getImpl((Remote)object);
        }
        if (object instanceof Proxy) {
            return ((Proxy)object).getRef();
        }
        return object;
    }

    public static List<Object> getLocal(Object[] objectArray) {
        if (null == objectArray) {
            return new ArrayList<Object>();
        }
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(MyRMI.getLocal(objectArray[i]));
        }
        return arrayList;
    }

    public static List<Object> getLocal(Collection<Object> collection) {
        if (null == collection) {
            return new ArrayList<Object>();
        }
        int n = collection.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        Iterator<Object> iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(MyRMI.getLocal(iterator.next()));
        }
        return arrayList;
    }

    public static boolean unexportObject(Remote remote, boolean bl) throws NoSuchObjectException {
        if (GlobalRMIFlags.getInstance().isLocalMode()) {
            return true;
        }
        return UnicastRemoteObject.unexportObject(remote, bl);
    }

    public static final void unexportUnicastRemoteObject(Remote remote) {
        if (GlobalRMIFlags.getInstance().isLocalMode()) {
            return;
        }
        boolean bl = false;
        try {
            bl = UnicastRemoteObject.unexportObject(remote, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (!bl) {
            LOG.error("Unable to unexport an object : " + remote.getClass().getName());
        }
    }
}

