/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.rmicallback;

import com.adesoft.log.Category;
import com.adesoft.rmi.DefaultSocketBehavior;
import com.adesoft.rmicallback.EndpointInfo;
import com.adesoft.rmicallback.SocketPool;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;

public class ServerTwoWaySocketFactory
extends RMIMasterSocketFactory {
    private Map socketPools = Collections.synchronizedMap(new HashMap());
    private Map requestStreams = Collections.synchronizedMap(new HashMap());
    private final Category LOG = Category.getInstance("com.adesoft.rmicallback.ServerTwoWaySocketFactory");
    private int registryPort;
    private int serverPort;

    public ServerTwoWaySocketFactory(int n, int n2) {
        this.registryPort = n;
        this.serverPort = n2;
    }

    public void addRequestSocket(final byte[] byArray, Socket socket) throws IOException {
        final DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        final DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
        new Thread(){

            @Override
            public void run() {
                try {
                    try {
                        while (true) {
                            int n = dataInputStream.readInt();
                            String string = EndpointInfo.getEndpointString(byArray, n);
                            ServerTwoWaySocketFactory.this.requestStreams.put(string, dataOutputStream);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (null != dataOutputStream) {
                                dataOutputStream.close();
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        try {
                            if (null != dataInputStream) {
                                dataInputStream.close();
                            }
                        }
                        catch (IOException iOException3) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (null != dataOutputStream) {
                            dataOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (null != dataInputStream) {
                            dataInputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocket(String string, int n) throws IOException {
        SocketPool socketPool;
        String string2 = EndpointInfo.getEndpointString(string, n);
        DataOutputStream dataOutputStream = (DataOutputStream)this.requestStreams.get(string2);
        if (dataOutputStream == null) {
            Socket socket = new Socket(string, n);
            DefaultSocketBehavior.applyServerBehavior(socket);
            return socket;
        }
        Map map = this.socketPools;
        synchronized (map) {
            socketPool = (SocketPool)this.socketPools.get(string2);
            if (socketPool == null) {
                socketPool = new SocketPool();
                this.socketPools.put(string2, socketPool);
            }
        }
        dataOutputStream.writeInt(23861);
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(n);
        dataOutputStream.flush();
        return socketPool.getSocket();
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        if (n == this.registryPort) {
            this.LOG.debug(" - Create two-way server socket on port " + this.registryPort);
            TwoWayServerSocket twoWayServerSocket = new TwoWayServerSocket(this.registryPort);
            DefaultSocketBehavior.applyServerBehavior(twoWayServerSocket);
            return twoWayServerSocket;
        }
        if (n != this.serverPort) {
            this.LOG.debug(" - Create server socket on port " + this.serverPort + " instead of " + n);
        } else {
            this.LOG.debug(" - Create server socket on port " + n);
        }
        ServerSocket serverSocket = super.createServerSocket(this.serverPort);
        DefaultSocketBehavior.applyServerBehavior(serverSocket);
        return serverSocket;
    }

    class TwoWayServerSocket
    extends ServerSocket {
        public TwoWayServerSocket(int n) throws IOException {
            super(n);
        }

        @Override
        public Socket accept() throws IOException {
            InputStream inputStream;
            BufferedSocket bufferedSocket = null;
            while (true) {
                byte[] byArray;
                int n;
                bufferedSocket = new BufferedSocket();
                DefaultSocketBehavior.applyServerBehavior(bufferedSocket);
                this.implAccept(bufferedSocket);
                inputStream = ((Socket)bufferedSocket).getInputStream();
                inputStream.mark(50);
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedSocket.getOutputStream());
                int n2 = 0;
                try {
                    n = bufferedSocket.getSoTimeout();
                    bufferedSocket.setSoTimeout(5000);
                    n2 = dataInputStream.readInt();
                    bufferedSocket.setSoTimeout(n);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    ServerTwoWaySocketFactory.this.LOG.error(" WARNING Phantom TCP connection from :" + bufferedSocket.getInetAddress().getHostAddress());
                    throw socketTimeoutException;
                }
                if (n2 != 23861) break;
                n = dataInputStream.readInt();
                if (n == 0) {
                    byArray = new byte[4];
                    dataInputStream.read(byArray, 0, 4);
                    ServerTwoWaySocketFactory.this.addRequestSocket(byArray, bufferedSocket);
                    dataOutputStream.writeInt(3);
                    dataOutputStream.write(InetAddress.getLocalHost().getAddress());
                    dataOutputStream.writeInt(bufferedSocket.getLocalPort());
                    dataOutputStream.flush();
                    continue;
                }
                if (n != 1) continue;
                byArray = new byte[4];
                dataInputStream.read(byArray, 0, 4);
                int n3 = dataInputStream.readInt();
                SocketPool socketPool = (SocketPool)ServerTwoWaySocketFactory.this.socketPools.get(EndpointInfo.getEndpointString(byArray, n3));
                if (null == socketPool) {
                    socketPool = (SocketPool)ServerTwoWaySocketFactory.this.socketPools.get(EndpointInfo.getEndpointString("127.0.0.1", n3));
                }
                socketPool.addSocket(bufferedSocket);
            }
            inputStream.reset();
            return bufferedSocket;
        }
    }

    private static class BufferedSocket
    extends Socket {
        InputStream in;

        BufferedSocket() {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.in == null) {
                this.in = new BufferedInputStream(super.getInputStream());
            }
            return this.in;
        }

        @Override
        public synchronized void close() throws IOException {
            super.close();
        }
    }
}

