/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.rmicallback;

import com.adesoft.rmi.DefaultSocketBehavior;
import com.adesoft.rmicallback.SocketAdapter;
import com.adesoft.rmicallback.TwoWay;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;

public class SignallingChannel
extends Thread {
    private String directAddress;
    private int directPort;
    private String destinationAddress;
    private int destinationPort;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private byte[] localAddress;

    public SignallingChannel(String string, int n) throws IOException {
        this.directAddress = string;
        this.directPort = n;
        this.socket = new Socket(string, n);
        DefaultSocketBehavior.applyClientBehavior(this.socket);
        this.in = new DataInputStream(this.socket.getInputStream());
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.localAddress = this.socket.getLocalAddress().getAddress();
        this.out.writeInt(23861);
        this.out.writeInt(0);
        this.out.write(this.localAddress);
        this.out.flush();
        this.in.readInt();
        byte[] byArray = new byte[4];
        this.in.read(byArray, 0, 4);
        this.destinationAddress = TwoWay.getAddressString(byArray);
        this.destinationPort = this.in.readInt();
    }

    public String getDirectAddress() {
        return this.directAddress;
    }

    public int getDirectPort() {
        return this.directPort;
    }

    public String getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public DataOutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void run() {
        try {
            while (true) {
                this.in.readInt();
                this.in.readInt();
                int n = this.in.readInt();
                Socket socket = null;
                try {
                    socket = new Socket(TwoWay.getAddressString(this.localAddress), n);
                    DefaultSocketBehavior.applyClientBehavior(socket);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Socket socket2 = new Socket(this.directAddress, this.directPort);
                DefaultSocketBehavior.applyClientBehavior(socket2);
                new SocketAdapter(socket, socket2);
                DataOutputStream dataOutputStream = new DataOutputStream(socket2.getOutputStream());
                dataOutputStream.writeInt(23861);
                dataOutputStream.writeInt(1);
                dataOutputStream.write(this.localAddress);
                dataOutputStream.writeInt(n);
                dataOutputStream.flush();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

