/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.jmdns;

import com.adesoft.jmdns.DNSEntry;
import java.util.Iterator;

class DNSCache {
    static final float LOAD_FACTOR = 0.75f;
    DNSEntry[] entries;
    int count;
    float loadFactor;

    DNSCache(int n) {
        n = Math.max(2, n * 2);
        while (n % 2 == 0 || n % 3 == 0 || n % 5 == 0) {
            ++n;
        }
        this.entries = new DNSEntry[n];
    }

    void add(DNSEntry dNSEntry) {
        if ((float)this.count >= (float)this.entries.length * 0.75f) {
            this.entries = this.rehash(this.entries, this.entries.length * 2);
        }
        this.add(this.entries, dNSEntry);
        ++this.count;
    }

    private void add(DNSEntry[] dNSEntryArray, DNSEntry dNSEntry) {
        int n = Math.abs(dNSEntry.key.hashCode()) % dNSEntryArray.length;
        while (dNSEntryArray[n] != null) {
            n = (n == 0 ? dNSEntryArray.length : n) - 1;
        }
        dNSEntryArray[n] = dNSEntry;
    }

    private DNSEntry[] rehash(DNSEntry[] dNSEntryArray, int n) {
        while (n % 2 == 0 || n % 3 == 0 || n % 5 == 0) {
            ++n;
        }
        DNSEntry[] dNSEntryArray2 = new DNSEntry[n];
        int n2 = dNSEntryArray.length;
        for (int i = 0; i < n2; ++i) {
            if (dNSEntryArray[i] == null) continue;
            this.add(dNSEntryArray2, dNSEntryArray[i]);
        }
        return dNSEntryArray2;
    }

    boolean remove(DNSEntry dNSEntry) {
        int n = Math.abs(dNSEntry.key.hashCode()) % this.entries.length;
        DNSEntry dNSEntry2;
        while ((dNSEntry2 = this.entries[n]) != null) {
            if (dNSEntry2 == dNSEntry) {
                this.remove(n);
                return true;
            }
            if (--n >= 0) continue;
            n = this.entries.length - 1;
        }
        return false;
    }

    private void remove(int n) {
        int n2 = n;
        this.entries[n2] = null;
        --this.count;
        while (true) {
            DNSEntry dNSEntry;
            if (--n < 0) {
                n = this.entries.length - 1;
            }
            if ((dNSEntry = this.entries[n]) == null) {
                return;
            }
            int n3 = Math.abs(dNSEntry.key.hashCode()) % this.entries.length;
            if (!(n < n2 ? n3 < n || n3 >= n2 : n3 < n && n3 >= n2)) continue;
            this.entries[n2] = dNSEntry;
            n2 = n;
            this.entries[n2] = null;
        }
    }

    DNSEntry get(DNSEntry dNSEntry) {
        int n = Math.abs(dNSEntry.key.hashCode()) % this.entries.length;
        DNSEntry dNSEntry2;
        while ((dNSEntry2 = this.entries[n]) != null) {
            if (dNSEntry2.equals(dNSEntry)) {
                return dNSEntry2;
            }
            if (--n >= 0) continue;
            n = this.entries.length - 1;
        }
        return null;
    }

    DNSEntry get(String string, int n, int n2) {
        String string2 = string.toLowerCase();
        int n3 = Math.abs(string2.hashCode()) % this.entries.length;
        DNSEntry dNSEntry;
        while ((dNSEntry = this.entries[n3]) != null) {
            if (string2.equals(dNSEntry.key) && n == dNSEntry.type && n2 == dNSEntry.clazz) {
                return dNSEntry;
            }
            if (--n3 >= 0) continue;
            n3 = this.entries.length - 1;
        }
        return null;
    }

    Iterator all() {
        return new IterateAll();
    }

    Iterator find(String string) {
        return new IterateKey(string.toLowerCase());
    }

    void print() {
        Iterator iterator = this.all();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    private class IterateKey
    implements Iterator {
        String key;
        int index;

        IterateKey(String string) {
            this.key = string;
            this.index = Math.abs(string.hashCode()) % DNSCache.this.entries.length;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                DNSEntry dNSEntry;
                if (this.index < 0) {
                    this.index = DNSCache.this.entries.length - 1;
                }
                if ((dNSEntry = DNSCache.this.entries[this.index]) == null) {
                    return false;
                }
                if (dNSEntry.key.equals(this.key)) {
                    return true;
                }
                --this.index;
            }
        }

        public Object next() {
            return DNSCache.this.entries[this.index--];
        }

        @Override
        public void remove() {
            DNSCache.this.remove(++this.index);
        }
    }

    private class IterateAll
    implements Iterator {
        int index;

        IterateAll() {
            this.index = DNSCache.this.entries.length - 1;
        }

        @Override
        public boolean hasNext() {
            while (this.index >= 0) {
                if (DNSCache.this.entries[this.index] != null) {
                    return true;
                }
                --this.index;
            }
            return false;
        }

        public Object next() {
            return DNSCache.this.entries[this.index--];
        }

        @Override
        public void remove() {
            DNSCache.this.remove(++this.index);
        }
    }
}

