/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.jmdns;

import com.adesoft.jmdns.DNSConstants;
import com.adesoft.jmdns.DNSOutgoing;
import com.adesoft.jmdns.DNSQuestion;
import com.adesoft.jmdns.DNSRecord;
import com.adesoft.jmdns.JmDNS;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ServiceInfo
extends JmDNS.Listener {
    public static final byte[] NO_VALUE = new byte[0];
    String type;
    String name;
    String server;
    int port;
    int weight;
    int priority;
    byte[] text;
    Hashtable props;
    InetAddress addr;

    public ServiceInfo(String string, String string2, int n, String string3) {
        this(string, string2, n, 0, 0, string3);
    }

    public ServiceInfo(String string, String string2, int n, int n2, int n3, String string3) {
        this(string, string2, n, n2, n3, (byte[])null);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string3.length());
            this.writeUTF(byteArrayOutputStream, string3);
            this.text = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("unexpected exception: " + iOException);
        }
    }

    public ServiceInfo(String string, String string2, int n, int n2, int n3, Hashtable hashtable) {
        this(string, string2, n, n2, n3, new byte[0]);
        if (hashtable != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
                Enumeration enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    byte[] byArray;
                    String string3 = (String)enumeration.nextElement();
                    Object v = hashtable.get(string3);
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(100);
                    this.writeUTF(byteArrayOutputStream2, string3);
                    if (v instanceof String) {
                        byteArrayOutputStream2.write(61);
                        this.writeUTF(byteArrayOutputStream2, (String)v);
                    } else if (v instanceof byte[]) {
                        byteArrayOutputStream2.write(61);
                        byArray = (byte[])v;
                        byteArrayOutputStream2.write(byArray, 0, byArray.length);
                    } else if (v != NO_VALUE) {
                        throw new IllegalArgumentException("invalid property value: " + v);
                    }
                    byArray = byteArrayOutputStream2.toByteArray();
                    byteArrayOutputStream.write(byArray.length);
                    byteArrayOutputStream.write(byArray, 0, byArray.length);
                }
                this.text = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new RuntimeException("unexpected exception: " + iOException);
            }
        }
    }

    public ServiceInfo(String string, String string2, int n, int n2, int n3, byte[] byArray) {
        this.type = string;
        this.name = string2;
        this.port = n;
        this.weight = n2;
        this.priority = n3;
        this.text = byArray;
    }

    ServiceInfo(String string, String string2) {
        if (!string.endsWith(".")) {
            throw new IllegalArgumentException("type must be fully qualified DNS name ending in '.': " + string);
        }
        if (string2.endsWith(".")) {
            if (!string2.endsWith("." + string)) {
                throw new IllegalArgumentException("service name has the wrong type: name=" + string2 + ", type=" + string);
            }
        } else {
            string2 = string2 + "." + string;
        }
        this.type = string;
        this.name = string2;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        if (this.type != null && this.name.endsWith("." + this.type)) {
            return this.name.substring(0, this.name.length() - (this.type.length() + 1));
        }
        return this.name;
    }

    public String getServer() {
        return this.server;
    }

    public String getAddress() {
        byte[] byArray = this.addr.getAddress();
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public int getPort() {
        return this.port;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWeight() {
        return this.weight;
    }

    public byte[] getTextBytes() {
        return this.text;
    }

    public String getTextString() {
        if (this.text == null || this.text.length == 0 || this.text.length == 1 && this.text[0] == 0) {
            return null;
        }
        return this.readUTF(this.text, 0, this.text.length);
    }

    public String getURL() {
        return this.getURL("http");
    }

    public String getURL(String string) {
        String string2 = string + "://" + this.getAddress() + ":" + this.getPort();
        String string3 = this.getPropertyString("path");
        if (string3 != null) {
            string2 = string3.indexOf("://") >= 0 ? string3 : string2 + (string3.startsWith("/") ? string3 : "/" + string3);
        }
        return string2;
    }

    public synchronized byte[] getPropertyBytes(String string) {
        return (byte[])this.getProperties().get(string);
    }

    public synchronized String getPropertyString(String string) {
        byte[] byArray = (byte[])this.getProperties().get(string);
        if (byArray == null) {
            return null;
        }
        if (byArray == NO_VALUE) {
            return "true";
        }
        return this.readUTF(byArray, 0, byArray.length);
    }

    public Enumeration getPropertyNames() {
        Hashtable hashtable = this.getProperties();
        return hashtable != null ? hashtable.keys() : new Vector().elements();
    }

    void writeUTF(OutputStream outputStream, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                outputStream.write(c);
                continue;
            }
            if (c > '\u07ff') {
                outputStream.write(0xE0 | c >> 12 & 0xF);
                outputStream.write(0x80 | c >> 6 & 0x3F);
                outputStream.write(0x80 | c >> 0 & 0x3F);
                continue;
            }
            outputStream.write(0xC0 | c >> 6 & 0x1F);
            outputStream.write(0x80 | c >> 0 & 0x3F);
        }
    }

    String readUTF(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n + n2;
        while (n < n3) {
            int n4 = byArray[n++] & 0xFF;
            switch (n4 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 12: 
                case 13: {
                    if (n >= n2) {
                        return null;
                    }
                    n4 = (n4 & 0x1F) << 6 | byArray[n++] & 0x3F;
                    break;
                }
                case 14: {
                    if (n + 2 >= n2) {
                        return null;
                    }
                    n4 = (n4 & 0xF) << 12 | (byArray[n++] & 0x3F) << 6 | byArray[n++] & 0x3F;
                    break;
                }
                default: {
                    if (n + 1 >= n2) {
                        return null;
                    }
                    n4 = (n4 & 0x3F) << 4 | byArray[n++] & 0xF;
                }
            }
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    synchronized Hashtable getProperties() {
        if (this.props == null && this.text != null) {
            Hashtable<String, byte[]> hashtable = new Hashtable<String, byte[]>();
            int n = 0;
            while (n < this.text.length) {
                int n2;
                int n3;
                if ((n3 = this.text[n++] & 0xFF) == 0 || n + n3 > this.text.length) {
                    hashtable.clear();
                    break;
                }
                for (n2 = 0; n2 < n3 && this.text[n + n2] != 61; ++n2) {
                }
                String string = this.readUTF(this.text, n, n2);
                if (string == null) {
                    hashtable.clear();
                    break;
                }
                if (n2 == n3) {
                    hashtable.put(string, NO_VALUE);
                    continue;
                }
                byte[] byArray = new byte[n3 - ++n2];
                System.arraycopy(this.text, n + n2, byArray, 0, n3 - n2);
                hashtable.put(string, byArray);
                n += n3;
            }
            this.props = hashtable;
        }
        return this.props;
    }

    int getIPAddress() {
        byte[] byArray = this.addr.getAddress();
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    @Override
    void updateRecord(JmDNS jmDNS, long l, DNSRecord dNSRecord) {
        if (dNSRecord != null && !dNSRecord.isExpired(l)) {
            switch (dNSRecord.type) {
                case 1: {
                    if (!dNSRecord.name.equals(this.server)) break;
                    this.addr = ((DNSRecord.Address)dNSRecord).getInetAddress();
                    break;
                }
                case 33: {
                    if (!dNSRecord.name.equals(this.name)) break;
                    DNSRecord.Service service = (DNSRecord.Service)dNSRecord;
                    this.server = service.server;
                    this.port = service.port;
                    this.weight = service.weight;
                    this.priority = service.priority;
                    this.addr = null;
                    this.updateRecord(jmDNS, l, (DNSRecord)jmDNS.cache.get(this.server, 1, 1));
                    break;
                }
                case 16: {
                    if (!dNSRecord.name.equals(this.name)) break;
                    DNSRecord.Text text = (DNSRecord.Text)dNSRecord;
                    this.text = text.text;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean request(JmDNS jmDNS, long l) {
        long l2 = System.currentTimeMillis();
        int n = 200;
        long l3 = l2 + (long)n;
        long l4 = l2 + l;
        try {
            jmDNS.addListener(this, new DNSQuestion(this.name, 255, 1));
            while (this.server == null || this.addr == null || this.text == null) {
                DNSConstants dNSConstants;
                if (l4 <= l2) {
                    boolean bl = false;
                    return bl;
                }
                if (l3 <= l2) {
                    dNSConstants = new DNSOutgoing(0);
                    ((DNSOutgoing)dNSConstants).addQuestion(new DNSQuestion(this.name, 33, 1));
                    ((DNSOutgoing)dNSConstants).addQuestion(new DNSQuestion(this.name, 16, 1));
                    if (this.server != null) {
                        ((DNSOutgoing)dNSConstants).addQuestion(new DNSQuestion(this.server, 1, 1));
                    }
                    ((DNSOutgoing)dNSConstants).addAnswer((DNSRecord)jmDNS.cache.get(this.name, 33, 1), l2);
                    ((DNSOutgoing)dNSConstants).addAnswer((DNSRecord)jmDNS.cache.get(this.name, 16, 1), l2);
                    if (this.server != null) {
                        ((DNSOutgoing)dNSConstants).addAnswer((DNSRecord)jmDNS.cache.get(this.server, 1, 1), l2);
                    }
                    jmDNS.send((DNSOutgoing)dNSConstants);
                    l3 = l2 + (long)n;
                    n *= 2;
                }
                dNSConstants = jmDNS;
                synchronized (dNSConstants) {
                    jmDNS.wait(Math.min(l3, l4) - l2);
                }
                l2 = System.currentTimeMillis();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException interruptedException) {
            boolean bl = false;
            return bl;
        }
        finally {
            jmDNS.removeListener(this);
        }
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ServiceInfo && this.name.equals(((ServiceInfo)object).name);
    }

    public String getNiceTextString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.text.length;
        for (int i = 0; i < n; ++i) {
            if (i >= 20) {
                stringBuffer.append("...");
                break;
            }
            int n2 = this.text[i] & 0xFF;
            if (n2 < 32 || n2 > 127) {
                stringBuffer.append("\\0");
                stringBuffer.append(Integer.toString(n2, 8));
                continue;
            }
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("service[");
        stringBuffer.append(this.name);
        stringBuffer.append(',');
        stringBuffer.append(this.getAddress());
        stringBuffer.append(':');
        stringBuffer.append(this.port);
        stringBuffer.append(',');
        stringBuffer.append(this.getNiceTextString());
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

