/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.patch;

import com.adesoft.jmdns.ServiceInfo;
import com.adesoft.jmdns.ServiceList;
import com.adesoft.jmdns.ZeroConfWrapper;
import com.adesoft.patch.DNSHost;
import com.adesoft.patch.JarUpdate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class Browser
implements ActionListener,
ListSelectionListener,
WindowListener,
FocusListener,
DocumentListener {
    private static final String PROTOCOL = "_rmi._tcp.local.";
    private static final String KEYWORDS = "com.adesoft.patch.res.Words";
    private static final String ACTION_CONNECT = "ACTION_CONNECT";
    private static final String PREFERENCES_ROOT = "/com/adesoft/patch/browser";
    private static final String PREFERENCES_HOST = "host";
    private static final String PREFERENCES_PORT = "port";
    private static final String PREFERENCES_DEFAULT_HOST = "127.0.0.1";
    private static final int PREFERENCES_DEFAULT_PORT = 1099;
    private static final String CLIENT_CLASSNAME = "com.adesoft.client.Client";
    private static final String SERVER_CLASSNAME = "com.adesoft.serverimpl.MainServerImpl";
    private final ServiceList services;
    private long lastUpdate;
    private final ResourceBundle bundle = ResourceBundle.getBundle("com.adesoft.patch.res.Words");
    private JTextField fieldHost;
    private JTextField fieldPort;
    private JPanel panelImage;
    private JList list;
    private JButton buttonConnect;
    private JFrame frame;
    private JPanel panel;
    private JScrollPane scroll;
    private JScrollPane scrollLog;
    private JTextArea errorLog;
    private boolean editMode;

    public Browser() throws IOException {
        this.services = new ServiceList(SERVER_CLASSNAME);
        this.startRendezVousListener();
        this.initialize();
        this.updateButtons();
        this.makeConnections();
    }

    private ServiceList getServices() {
        return this.services;
    }

    private JPanel getPanelImageContainer() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getPanelImage(), "North");
        return jPanel;
    }

    private JPanel getPanelImage() {
        if (null == this.panelImage) {
            Serializable serializable;
            final Image image = Browser.load(this.bundle.getString("Image"));
            this.panelImage = new JPanel(){
                private static final long serialVersionUID = 520L;

                @Override
                public void paintComponent(Graphics graphics) {
                    graphics.drawImage(image, 0, 0, this);
                }
            };
            this.panelImage.setBorder(BorderFactory.createBevelBorder(1));
            try {
                serializable = new MediaTracker(this.panelImage);
                serializable.addImage(image, 0);
                serializable.waitForAll();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            serializable = new Dimension(image.getWidth(this.panelImage), image.getHeight(this.panelImage));
            this.panelImage.setSize((Dimension)serializable);
            this.panelImage.setPreferredSize((Dimension)serializable);
            this.panelImage.setMinimumSize((Dimension)serializable);
            this.panelImage.setMaximumSize((Dimension)serializable);
        }
        return this.panelImage;
    }

    private JTextField getFieldHost() {
        if (null == this.fieldHost) {
            this.fieldHost = new JTextField();
        }
        return this.fieldHost;
    }

    private JTextField getFieldPort() {
        if (null == this.fieldPort) {
            this.fieldPort = new JTextField();
        }
        return this.fieldPort;
    }

    private JList getList() {
        if (null == this.list) {
            this.list = new JList();
            this.list.setPreferredSize(new Dimension(200, 150));
            this.list.setSelectionMode(0);
        }
        return this.list;
    }

    private JButton getButtonConnect() {
        if (null == this.buttonConnect) {
            this.buttonConnect = new JButton(this.bundle.getString("ButtonConnect"));
            this.buttonConnect.setActionCommand(ACTION_CONNECT);
        }
        return this.buttonConnect;
    }

    private JPanel getPanel() {
        if (null == this.panel) {
            this.panel = new JPanel();
            this.panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
            this.panel.setLayout(new BorderLayout(10, 10));
            this.panel.add((Component)this.getPanelImageContainer(), "West");
            this.panel.add((Component)this.getPanelList(), "Center");
        }
        return this.panel;
    }

    private JPanel getPanelButtons() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(-1, 1, 0, 0));
        jPanel.add(new JLabel(this.bundle.getString("LabelCustom") + this.bundle.getString("LabelFieldSep")));
        jPanel.add(this.getPanelFields());
        jPanel.add(new JPanel());
        jPanel.add(this.getButtonConnect());
        return jPanel;
    }

    private JPanel getPanelFields() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 5));
        jPanel.add(this.getFieldHost());
        jPanel.add(this.getFieldPort());
        return jPanel;
    }

    private JPanel getPanelList() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.add((Component)new JLabel(this.bundle.getString("LabelDetected") + this.bundle.getString("LabelFieldSep")), "North");
        jPanel.add((Component)this.getScroll(), "Center");
        jPanel.add((Component)this.getPanelButtons(), "South");
        return jPanel;
    }

    private JScrollPane getScroll() {
        if (null == this.scroll) {
            this.scroll = new JScrollPane(this.getList());
        }
        return this.scroll;
    }

    private JScrollPane getScrollLog() {
        if (null == this.scrollLog) {
            this.scrollLog = new JScrollPane(this.getErrorLog());
        }
        return this.scrollLog;
    }

    private JFrame getFrame() {
        if (null == this.frame) {
            this.frame = new JFrame(this.bundle.getString("WindowTitle"));
            this.frame.getContentPane().add((Component)this.getPanel(), "Center");
        }
        return this.frame;
    }

    private JTextArea getErrorLog() {
        if (null == this.errorLog) {
            this.errorLog = new JTextArea();
            this.errorLog.setPreferredSize(new Dimension(0, 75));
            this.errorLog.setEnabled(false);
        }
        return this.errorLog;
    }

    private void initialize() {
        this.restoreCustomValue();
        this.getFrame().pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.getFrame().setLocation((int)((dimension.getWidth() - (double)this.getFrame().getWidth()) / 2.0), (int)((dimension.getHeight() - (double)this.getFrame().getHeight()) * 0.382));
        this.getFrame().addWindowListener(this);
        this.getFrame().setDefaultCloseOperation(2);
        this.getFrame().setVisible(true);
        this.getFieldHost().requestFocus();
        this.getFieldHost().select(0, this.getFieldHost().getText().length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateList() {
        try {
            this.editMode = true;
            long l = this.getServices().lastUpdate();
            if (this.lastUpdate < l) {
                int n;
                this.lastUpdate = l;
                Object e = this.getList().getSelectedValue();
                ServiceInfo[] serviceInfoArray = this.getServices().getAllInfo();
                String[] stringArray = new String[serviceInfoArray.length];
                for (n = 0; n < serviceInfoArray.length; ++n) {
                    String string = serviceInfoArray[n].getTextString();
                    int n2 = string.lastIndexOf(58);
                    string = string.substring(n2 + 1);
                    stringArray[n] = serviceInfoArray[n].getName() + " (" + string + ") [" + serviceInfoArray[n].getAddress() + ":" + serviceInfoArray[n].getPort() + "]";
                }
                this.getList().setListData(stringArray);
                n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(e)) continue;
                    n = 1;
                    this.getList().setSelectedIndex(i);
                }
                if (n == 0) {
                    this.getList().clearSelection();
                }
                this.getList().invalidate();
                this.getScroll().revalidate();
                this.getScroll().repaint();
                this.updateButtons();
            }
        }
        finally {
            this.editMode = false;
        }
    }

    private void startRendezVousListener() throws IOException {
        ZeroConfWrapper.getInstance().addServiceListener(PROTOCOL, this.getServices());
    }

    private void makeConnections() {
        this.getButtonConnect().addActionListener(this);
        this.getList().addListSelectionListener(this);
        this.getFieldHost().addFocusListener(this);
        this.getFieldPort().addFocusListener(this);
        this.getFieldHost().getDocument().addDocumentListener(this);
        this.getFieldPort().getDocument().addDocumentListener(this);
    }

    public void test() {
        while (true) {
            this.updateList();
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
            }
        }
    }

    private DNSHost getSelectedHost() {
        try {
            int n = this.getList().getSelectedIndex();
            if (-1 != n) {
                ServiceInfo serviceInfo = this.getServices().getInfo(n);
                String string = serviceInfo.getTextString();
                int n2 = string.lastIndexOf(58);
                string = string.substring(n2 + 1);
                return new DNSHost(serviceInfo.getName(), serviceInfo.getAddress(), string, serviceInfo.getPort());
            }
            String string = this.getFieldHost().getText();
            int n3 = Integer.parseInt(this.getFieldPort().getText());
            return new DNSHost(string, string, "ade", n3);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private synchronized void connect() {
        DNSHost dNSHost = this.getSelectedHost();
        if (null != dNSHost) {
            try {
                JarUpdate jarUpdate = new JarUpdate(dNSHost.getHost(), dNSHost.getPort(), false);
                jarUpdate.update();
                String[] stringArray = new String[]{"Server=" + dNSHost.getHost(), "RmiRegistryPort=" + dNSHost.getPort(), "RmiName=" + dNSHost.getName()};
                Class[] classArray = new Class[]{String[].class};
                Object[] objectArray = new Object[]{stringArray};
                this.getFrame().setVisible(false);
                Class.forName(CLIENT_CLASSNAME).getMethod("main", classArray).invoke(null, objectArray);
            }
            catch (Throwable throwable) {
                this.getErrorLog().setText(throwable.toString());
                this.getPanel().add((Component)this.getScrollLog(), "South");
                this.getFrame().pack();
                this.getFrame().setVisible(true);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (ACTION_CONNECT == string) {
                this.connect();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void updateButtons() {
        boolean bl;
        boolean bl2 = -1 != this.getList().getSelectedIndex();
        boolean bl3 = bl = this.getFieldHost().getText().length() != 0 && this.getFieldPort().getText().length() != 0 && (this.getFieldHost().hasFocus() || this.getFieldPort().hasFocus());
        if (bl2 || bl) {
            DNSHost dNSHost = this.getSelectedHost();
            this.getButtonConnect().setLabel(this.bundle.getString("ButtonConnectTo") + " " + dNSHost.getServerName() + " (" + dNSHost.getName() + ")");
            this.getButtonConnect().setEnabled(true);
        } else {
            this.getButtonConnect().setLabel(this.bundle.getString("ButtonConnect"));
            this.getButtonConnect().setEnabled(false);
        }
    }

    private static Image load(String string) {
        try {
            return Toolkit.getDefaultToolkit().createImage(Browser.class.getResource(string));
        }
        catch (Exception exception) {
            System.err.println("Error trying to load image " + string);
            return null;
        }
    }

    private void saveCustomValue() {
        Preferences preferences = Preferences.userRoot().node(PREFERENCES_ROOT);
        preferences.put(PREFERENCES_HOST, this.getFieldHost().getText());
        try {
            preferences.putInt(PREFERENCES_PORT, Integer.parseInt(this.getFieldPort().getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void restoreCustomValue() {
        Preferences preferences = Preferences.userRoot().node(PREFERENCES_ROOT);
        String string = preferences.get(PREFERENCES_HOST, PREFERENCES_DEFAULT_HOST);
        int n = preferences.getInt(PREFERENCES_PORT, 1099);
        this.getFieldHost().setText(string);
        this.getFieldPort().setText(String.valueOf(n));
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        try {
            if (!this.editMode) {
                this.updateButtons();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        System.exit(0);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.saveCustomValue();
        this.updateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.saveCustomValue();
        this.updateButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.saveCustomValue();
        this.updateButtons();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        try {
            if (this.getFieldHost() == focusEvent.getSource()) {
                this.getList().clearSelection();
            } else if (this.getFieldPort() == focusEvent.getSource()) {
                this.getList().clearSelection();
            }
            this.updateButtons();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public static void main(String[] stringArray) {
        try {
            Browser browser = new Browser();
            browser.test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

