/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.patch;

import com.adesoft.patch.FileVersion;
import com.adesoft.patch.UpdateProvider;
import com.dautelle.xml.sax.XMLReaderImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.Remote;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Checker
extends DefaultHandler {
    private static final String CONFIG_FILE = "Client.properties";
    private static final int MAX_TRY = 3;
    private static final int TIMEOUT = 5000;
    private static final int HEIGHT = 50;
    private static final int WIDTH = 550;
    private final boolean forceUpdate;
    private UpdateProvider _server;
    private final FileVersion versions;
    private JProgressBar progressBar;
    private JFrame frame;

    public Checker(boolean bl) {
        this.forceUpdate = bl;
        this.versions = new FileVersion();
    }

    private boolean isForceUpdate() {
        return this.forceUpdate;
    }

    private UpdateProvider getServer() throws IOException {
        if (null == this._server) {
            TreeMap treeMap = Checker.readPropertiesFile(new File(CONFIG_FILE));
            String string = (String)treeMap.get("Server");
            int n = Integer.parseInt((String)treeMap.get("RmiRegistryPort"));
            this._server = (UpdateProvider)Checker.getServer(string, "update", n);
        }
        return this._server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServerFile(String string) throws IOException {
        byte[] byArray = this.getServer().readFile(string);
        if (null != byArray) {
            File file = new File("lib" + File.separator + string);
            file.getParentFile().mkdirs();
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
            }
        }
    }

    private String getVersions() throws IOException {
        return this.getServer().getXmlLibs();
    }

    public void updateFiles() throws IOException, SAXException {
        try {
            String string = this.getVersions();
            this.check(string);
        }
        finally {
            if (null != this.frame) {
                this.frame.dispose();
            }
        }
    }

    private void check(String string) throws IOException, SAXException {
        XMLReaderImpl xMLReaderImpl = new XMLReaderImpl();
        xMLReaderImpl.setContentHandler(this);
        xMLReaderImpl.setErrorHandler(this);
        xMLReaderImpl.setFeature("http://xml.org/sax/features/validation", false);
        xMLReaderImpl.setFeature("http://xml.org/sax/features/namespaces", false);
        xMLReaderImpl.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        InputSource inputSource = new InputSource(new StringReader(string));
        inputSource.setEncoding("UTF-8");
        xMLReaderImpl.parse(inputSource);
    }

    private static Object getServer(String string, String string2, int n) {
        Throwable throwable = null;
        Remote remote = null;
        String string3 = "rmi://" + string + ":" + n + "/" + string2;
        for (int i = 3; i > 0; --i) {
            block8: {
                try {
                    remote = Naming.lookup(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Unknown url : " + string);
                }
                catch (Throwable throwable2) {
                    if (null != throwable) break block8;
                    throwable = throwable2;
                }
            }
            if (null != remote) {
                return remote;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
        if (null != throwable) {
            throw new RuntimeException("Connection to (" + string3 + ") impossible. Error : '" + throwable.getMessage() + "'");
        }
        throw new RuntimeException("Unable to get " + string3);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("file".equals(string3)) {
            String string4 = attributes.getValue("name");
            String string5 = attributes.getValue("crc");
            if (null == string5) {
                string5 = "";
            }
            try {
                boolean bl = false;
                if (this.isForceUpdate()) {
                    this.showMessage("Get latest jar: " + string4 + " (force mode)");
                    bl = true;
                } else {
                    File file = new File("lib" + File.separator + string4);
                    if (!file.exists()) {
                        this.showMessage("Get jar: " + string4);
                        bl = true;
                    } else if (!string5.equals(this.versions.getVersion(file))) {
                        this.showMessage("Get latest jar: " + string4);
                        bl = true;
                    }
                }
                if (bl) {
                    this.getServerFile(string4);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TreeMap readPropertiesFile(File file) throws IOException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while (null != (string = bufferedReader.readLine())) {
                int n;
                if ((string = Checker.removeLeadingSpaces(string)).startsWith("#") || -1 == (n = string.indexOf(61))) continue;
                String string2 = string.substring(0, n).trim();
                String string3 = string.substring(1 + n);
                string3 = Checker.loadConvert(string3);
                treeMap.put(string2, string3);
            }
        }
        finally {
            if (null != bufferedReader) {
                bufferedReader.close();
            }
        }
        return treeMap;
    }

    private static String removeLeadingSpaces(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        return n > 0 ? string.substring(n, n2) : string;
    }

    private static String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    private void showMessage(String string) {
        System.out.println(string);
        if (null == this.progressBar) {
            this.showWaitingDialog();
        }
        if (null != this.progressBar) {
            this.progressBar.setString(string);
        }
    }

    private void showWaitingDialog() {
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorderPainted(true);
        this.frame = new JFrame("ADE");
        this.frame.getContentPane().add((Component)this.progressBar, "Center");
        this.frame.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setBounds(dimension.width / 2 - 275, dimension.height / 2 - 25, 550, 50);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            if (null != stringArray && stringArray.length > 0 && "force".equalsIgnoreCase(stringArray[0])) {
                bl = true;
            }
            Checker checker = new Checker(bl);
            checker.updateFiles();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(0);
    }
}

