/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.patch;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;

public final class FileVersion {
    public byte[] getCrc(File file) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        while ((n = fileInputStream.read(byArray)) > 0) {
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        return messageDigest.digest();
    }

    private static String asHex(byte[] byArray) {
        int n = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(2 * n);
        for (int i = 0; i < n; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Long.toString(byArray[i] & 0xFF, 16));
        }
        return stringBuffer.toString();
    }

    public String getVersion(File file) {
        String string;
        try {
            string = FileVersion.asHex(this.getCrc(file));
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }
}

