/*
 * Decompiled with CFR 0.152.
 */
package com.adesoft.patch;

import com.adesoft.patch.FileVersion;
import com.adesoft.patch.UpdateProvider;
import com.dautelle.xml.sax.XMLReaderImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.Naming;
import java.rmi.Remote;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class JarUpdate
extends DefaultHandler {
    private static final int MAX_TRY = 3;
    private static final int TIMEOUT = 5000;
    private static final int HEIGHT = 50;
    private static final int WIDTH = 550;
    private final boolean forceUpdate;
    private final String host;
    private final int port;
    private UpdateProvider _server;
    private final FileVersion versions;
    private JProgressBar progressBar;
    private JFrame frame;

    public JarUpdate(String string, int n, boolean bl) {
        this.forceUpdate = bl;
        this.host = string;
        this.port = n;
        this.versions = new FileVersion();
    }

    private boolean isForceUpdate() {
        return this.forceUpdate;
    }

    private UpdateProvider getServer() {
        if (null == this._server) {
            this._server = (UpdateProvider)JarUpdate.getServer(this.host, "update", this.port);
        }
        return this._server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getServerFile(String string) throws IOException {
        byte[] byArray = this.getServer().readFile(string);
        if (null != byArray) {
            File file = new File("lib" + File.separator + string);
            file.getParentFile().mkdirs();
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.flush();
            }
        }
    }

    private String getVersions() throws IOException {
        return this.getServer().getXmlLibs();
    }

    private void updateFiles() throws IOException, SAXException {
        try {
            String string = this.getVersions();
            this.check(string);
        }
        finally {
            if (null != this.frame) {
                this.frame.dispose();
            }
        }
    }

    private void check(String string) throws IOException, SAXException {
        XMLReaderImpl xMLReaderImpl = new XMLReaderImpl();
        xMLReaderImpl.setContentHandler(this);
        xMLReaderImpl.setErrorHandler(this);
        xMLReaderImpl.setFeature("http://xml.org/sax/features/validation", false);
        xMLReaderImpl.setFeature("http://xml.org/sax/features/namespaces", false);
        xMLReaderImpl.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        InputSource inputSource = new InputSource(new StringReader(string));
        inputSource.setEncoding("UTF-8");
        xMLReaderImpl.parse(inputSource);
    }

    private static Object getServer(String string, String string2, int n) {
        Throwable throwable = null;
        Remote remote = null;
        String string3 = "rmi://" + string + ":" + n + "/" + string2;
        for (int i = 3; i > 0; --i) {
            block8: {
                try {
                    remote = Naming.lookup(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Unknown url : " + string);
                }
                catch (Throwable throwable2) {
                    if (null != throwable) break block8;
                    throwable = throwable2;
                }
            }
            if (null != remote) {
                return remote;
            }
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
        if (null != throwable) {
            throw new RuntimeException("Connection to (" + string3 + ") impossible. Error : '" + throwable.getMessage() + "'");
        }
        throw new RuntimeException("Unable to get " + string3);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("file".equals(string3)) {
            String string4 = attributes.getValue("name");
            String string5 = attributes.getValue("crc");
            if (null == string5) {
                string5 = "";
            }
            try {
                boolean bl = false;
                if (this.isForceUpdate()) {
                    this.showMessage("Get latest jar: " + string4 + " (force mode)");
                    bl = true;
                } else {
                    File file = new File("lib" + File.separator + string4);
                    if (!file.exists()) {
                        this.showMessage("Get jar: " + string4);
                        bl = true;
                    } else if (!string5.equals(this.versions.getVersion(file))) {
                        this.showMessage("Get latest jar: " + string4);
                        bl = true;
                    }
                }
                if (bl) {
                    this.getServerFile(string4);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void showMessage(String string) {
        System.out.println(string);
        if (null == this.progressBar) {
            this.showWaitingDialog();
        }
        if (null != this.progressBar) {
            this.progressBar.setString(string);
        }
    }

    private void showWaitingDialog() {
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setStringPainted(true);
        this.progressBar.setBorderPainted(true);
        this.frame = new JFrame("ADE");
        this.frame.getContentPane().add((Component)this.progressBar, "Center");
        this.frame.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setBounds(dimension.width / 2 - 275, dimension.height / 2 - 25, 550, 50);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private void updateClasspath() {
        File[] fileArray = new File("lib").listFiles();
        if (null != fileArray) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getName().endsWith(".jar") && !fileArray[i].getName().endsWith(".zip")) continue;
                URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<URLClassLoader> clazz = URLClassLoader.class;
                try {
                    Class[] classArray = new Class[]{URL.class};
                    Method method = clazz.getDeclaredMethod("addURL", classArray);
                    method.setAccessible(true);
                    method.invoke((Object)uRLClassLoader, fileArray[i].toURL());
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    public void update() throws IOException, SAXException {
        this.updateFiles();
        this.updateClasspath();
    }

    public static void main(String[] stringArray) {
        try {
            JarUpdate jarUpdate = new JarUpdate("127.0.0.1", 1099, false);
            jarUpdate.update();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(0);
    }
}

